/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.application;

import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ApplicationStartupMode;
import io.ktor.server.config.ApplicationConfigValue;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\"\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\r\u001a\u00020\n*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lio/ktor/server/application/ApplicationEnvironment;", "", "", "getModuleConfigReferences", "(Lio/ktor/server/application/ApplicationEnvironment;)Ljava/util/List;", "moduleConfigReferences", "Lio/ktor/server/application/ApplicationStartupMode;", "getStartupMode", "(Lio/ktor/server/application/ApplicationEnvironment;)Lio/ktor/server/application/ApplicationStartupMode;", "startupMode", "Lkotlin/time/Duration;", "getStartupTimeout", "(Lio/ktor/server/application/ApplicationEnvironment;)J", "startupTimeout", "ktor-server-core"})
public final class ApplicationModulesKt {
    @NotNull
    public static final List<String> getModuleConfigReferences(@NotNull ApplicationEnvironment $this$moduleConfigReferences) {
        Intrinsics.checkNotNullParameter((Object)$this$moduleConfigReferences, (String)"<this>");
        ApplicationConfigValue applicationConfigValue = $this$moduleConfigReferences.getConfig().propertyOrNull("ktor.application.modules");
        List list = applicationConfigValue != null ? applicationConfigValue.getList() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final ApplicationStartupMode getStartupMode(@NotNull ApplicationEnvironment $this$startupMode) {
        ApplicationStartupMode applicationStartupMode;
        String text;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$startupMode, (String)"<this>");
        Object object = $this$startupMode.getConfig().propertyOrNull("ktor.application.startup");
        if (object != null && (object = object.getString()) != null) {
            String string2 = ((String)object).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = text = null;
        }
        if (Intrinsics.areEqual((Object)text, (Object)"concurrent")) {
            applicationStartupMode = ApplicationStartupMode.CONCURRENT;
        } else if (Intrinsics.areEqual((Object)text, (Object)"sequential") || text == null) {
            applicationStartupMode = ApplicationStartupMode.SEQUENTIAL;
        } else {
            throw new IllegalStateException(("Invalid startup mode: " + text).toString());
        }
        return applicationStartupMode;
    }

    public static final long getStartupTimeout(@NotNull ApplicationEnvironment $this$startupTimeout) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$startupTimeout, (String)"<this>");
        Object object = $this$startupTimeout.getConfig().propertyOrNull("ktor.application.startupTimeoutMillis");
        if (object != null && (object = object.getString()) != null) {
            long l2 = Long.parseLong((String)object);
            l = DurationKt.toDuration((long)l2, (DurationUnit)DurationUnit.MILLISECONDS);
        } else {
            l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
        }
        return l;
    }
}

