/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteConnectionUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import com.ustadmobile.libcache.db.DbTypeConverters;
import com.ustadmobile.libcache.db.dao.DownloadJobDao;
import com.ustadmobile.libcache.db.entities.DownloadJob;
import io.ktor.http.Url;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0004\b\u0010\u0010\u000eJ \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0004\b\u0013\u0010\u0014J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/ustadmobile/libcache/db/dao/DownloadJobDao_Impl;", "Lcom/ustadmobile/libcache/db/dao/DownloadJobDao;", "Landroidx/room/RoomDatabase;", "__db", "<init>", "(Landroidx/room/RoomDatabase;)V", "Lcom/ustadmobile/libcache/db/entities/DownloadJob;", "downloadJob", "", "insert", "(Lcom/ustadmobile/libcache/db/entities/DownloadJob;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "uid", "findByUid", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "jobUid", "updateStatusSetCompleteIfAllItemsComplete", "status", "", "updateStatus", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "manifestHash", "updateStatusByManifestHash", "(JILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Landroidx/room/RoomDatabase;", "Landroidx/room/EntityInsertAdapter;", "__insertAdapterOfDownloadJob", "Landroidx/room/EntityInsertAdapter;", "Lcom/ustadmobile/libcache/db/DbTypeConverters;", "__dbTypeConverters", "Lcom/ustadmobile/libcache/db/DbTypeConverters;", "Companion", "respect-lib-cache"})
public final class DownloadJobDao_Impl
extends DownloadJobDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<DownloadJob> __insertAdapterOfDownloadJob;
    @NotNull
    private final DbTypeConverters __dbTypeConverters;

    public DownloadJobDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__dbTypeConverters = new DbTypeConverters();
        this.__db = __db;
        this.__insertAdapterOfDownloadJob = (EntityInsertAdapter)new EntityInsertAdapter<DownloadJob>(){

            protected String createQuery() {
                return "INSERT OR ABORT INTO `DownloadJob` (`djUid`,`djType`,`djStatus`,`djName`,`djPubManifestUrl`,`djPubManifestHash`,`djTimeCreated`,`djCreationType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, DownloadJob entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, (long)entity.getDjUid());
                statement.bindLong(2, (long)entity.getDjType());
                statement.bindLong(3, (long)entity.getDjStatus());
                String _tmpDjName = entity.getDjName();
                if (_tmpDjName == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmpDjName);
                }
                Url _tmpDjPubManifestUrl = entity.getDjPubManifestUrl();
                String _tmp = __dbTypeConverters.fromUrl(_tmpDjPubManifestUrl);
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                statement.bindLong(6, entity.getDjPubManifestHash());
                statement.bindLong(7, entity.getDjTimeCreated());
                statement.bindLong(8, (long)entity.getDjCreationType());
            }
        };
    }

    @Override
    @Nullable
    public Object insert(@NotNull DownloadJob downloadJob, @NotNull Continuation<? super Long> $completion) {
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> DownloadJobDao_Impl.insert$lambda$0(this, downloadJob, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByUid(int uid, @NotNull Continuation<? super DownloadJob> $completion) {
        String _sql = "\n        SELECT * \n          FROM DownloadJob \n         WHERE djUid = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> DownloadJobDao_Impl.findByUid$lambda$0(_sql, uid, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object updateStatusSetCompleteIfAllItemsComplete(int jobUid, @NotNull Continuation<? super Integer> $completion) {
        String _sql = "\n        UPDATE DownloadJob\n           SET djStatus = 21\n         WHERE djUid = ?\n          AND NOT EXISTS(\n              SELECT DownloadJobItem.djiUid\n                FROM DownloadJobItem\n               WHERE DownloadJobItem.djiDjUid = ?\n                 AND DownloadJobItem.djiStatus != 21) \n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> DownloadJobDao_Impl.updateStatusSetCompleteIfAllItemsComplete$lambda$0(_sql, jobUid, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object updateStatus(int jobUid, int status, @NotNull Continuation<? super Unit> $completion) {
        String _sql = "\n        UPDATE DownloadJob\n           SET djStatus = ?\n         WHERE djUid = ?\n    ";
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> DownloadJobDao_Impl.updateStatus$lambda$0(_sql, status, jobUid, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object updateStatusByManifestHash(long manifestHash, int status, @NotNull Continuation<? super Unit> $completion) {
        String _sql = "\n        UPDATE DownloadJob\n           SET djStatus = ?\n         WHERE DownloadJob.djPubManifestHash = ?\n    ";
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> DownloadJobDao_Impl.updateStatusByManifestHash$lambda$0(_sql, status, manifestHash, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final long insert$lambda$0(DownloadJobDao_Impl this$0, DownloadJob $downloadJob, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        long _result = this$0.__insertAdapterOfDownloadJob.insertAndReturnId(_connection, (Object)$downloadJob);
        return _result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DownloadJob findByUid$lambda$0(String $_sql, int $uid, DownloadJobDao_Impl this$0, SQLiteConnection _connection) {
        DownloadJob downloadJob;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)$uid);
            int _columnIndexOfDjUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"djUid");
            int _columnIndexOfDjType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"djType");
            int _columnIndexOfDjStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"djStatus");
            int _columnIndexOfDjName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"djName");
            int _columnIndexOfDjPubManifestUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"djPubManifestUrl");
            int _columnIndexOfDjPubManifestHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"djPubManifestHash");
            int _columnIndexOfDjTimeCreated = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"djTimeCreated");
            int _columnIndexOfDjCreationType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"djCreationType");
            DownloadJob _result = null;
            if (_stmt.step()) {
                int _tmpDjUid = 0;
                _tmpDjUid = (int)_stmt.getLong(_columnIndexOfDjUid);
                int _tmpDjType = 0;
                _tmpDjType = (int)_stmt.getLong(_columnIndexOfDjType);
                int _tmpDjStatus = 0;
                _tmpDjStatus = (int)_stmt.getLong(_columnIndexOfDjStatus);
                String _tmpDjName = null;
                _tmpDjName = _stmt.isNull(_columnIndexOfDjName) ? null : _stmt.getText(_columnIndexOfDjName);
                Url _tmpDjPubManifestUrl = null;
                String _tmp = null;
                _tmp = _stmt.isNull(_columnIndexOfDjPubManifestUrl) ? null : _stmt.getText(_columnIndexOfDjPubManifestUrl);
                _tmpDjPubManifestUrl = this$0.__dbTypeConverters.toUrl(_tmp);
                long _tmpDjPubManifestHash = 0L;
                _tmpDjPubManifestHash = _stmt.getLong(_columnIndexOfDjPubManifestHash);
                long _tmpDjTimeCreated = 0L;
                _tmpDjTimeCreated = _stmt.getLong(_columnIndexOfDjTimeCreated);
                int _tmpDjCreationType = 0;
                _tmpDjCreationType = (int)_stmt.getLong(_columnIndexOfDjCreationType);
                _result = new DownloadJob(_tmpDjUid, _tmpDjType, _tmpDjStatus, _tmpDjName, _tmpDjPubManifestUrl, _tmpDjPubManifestHash, _tmpDjTimeCreated, _tmpDjCreationType);
            } else {
                _result = null;
            }
            downloadJob = _result;
        }
        return downloadJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int updateStatusSetCompleteIfAllItemsComplete$lambda$0(String $_sql, int $jobUid, SQLiteConnection _connection) {
        int n;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)$jobUid);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, (long)$jobUid);
            _stmt.step();
            n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateStatus$lambda$0(String $_sql, int $status, int $jobUid, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)$status);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, (long)$jobUid);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateStatusByManifestHash$lambda$0(String $_sql, int $status, long $manifestHash, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)$status);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, $manifestHash);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ustadmobile/libcache/db/dao/DownloadJobDao_Impl$Companion;", "", "<init>", "()V", "", "Lkotlin/reflect/KClass;", "getRequiredConverters", "()Ljava/util/List;", "respect-lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

