/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.nio.ByteBuffer;

public class Version {
    public static final Version IETF_draft_16 = new Version(-16777200);
    public static final Version IETF_draft_17 = new Version(-16777199);
    public static final Version IETF_draft_18 = new Version(-16777198);
    public static final Version IETF_draft_19 = new Version(-16777197);
    public static final Version IETF_draft_20 = new Version(-16777196);
    public static final Version IETF_draft_22 = new Version(-16777194);
    public static final Version IETF_draft_27 = new Version(-16777189);
    public static final Version IETF_draft_29 = new Version(-16777187);
    public static final Version IETF_draft_30 = new Version(-16777186);
    public static final Version IETF_draft_31 = new Version(-16777185);
    public static final Version IETF_draft_32 = new Version(-16777184);
    public static final Version IETF_draft_33 = new Version(-16777183);
    public static final Version IETF_draft_34 = new Version(-16777182);
    public static final Version QUIC_version_1 = new Version(1);
    public static final Version QUIC_version_2 = new Version(1798521807);
    public static final Version reserved_1 = new Version(438975050);
    private int versionId;

    Version(int versionId) {
        this.versionId = versionId;
    }

    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(this.versionId);
        return buffer.array();
    }

    public static Version parse(int input) {
        return new Version(input);
    }

    public static Version getDefault() {
        return QUIC_version_1;
    }

    public boolean isKnown() {
        return this.isDraftVersion(this.versionId) || this.versionId == Version.QUIC_version_1.versionId || this.versionId == Version.QUIC_version_2.versionId;
    }

    public boolean isZero() {
        return this.versionId == 0;
    }

    public boolean isV1() {
        return this.versionId == Version.QUIC_version_1.versionId;
    }

    public boolean isV2() {
        return this.versionId == Version.QUIC_version_2.versionId;
    }

    public boolean isV1V2() {
        return this.versionId == Version.QUIC_version_1.versionId || this.versionId == Version.QUIC_version_2.versionId;
    }

    public boolean atLeast(Version other) {
        return this.compare(other) >= 0;
    }

    public boolean before(Version other) {
        return this.compare(other) < 0;
    }

    private int compare(Version other) {
        if (this.isKnown() && other.isKnown()) {
            if (this.isDraftVersion(this.versionId) && this.isDraftVersion(other.versionId)) {
                return Integer.compare(this.versionId, other.versionId);
            }
            if (this.isDraftVersion(this.versionId) && !this.isDraftVersion(other.versionId)) {
                return -1;
            }
            if (!this.isDraftVersion(this.versionId) && this.isDraftVersion(other.versionId)) {
                return 1;
            }
            return Integer.compare(this.versionId, other.versionId);
        }
        throw new IllegalArgumentException();
    }

    private boolean isDraftVersion(int version) {
        return version > -16777216 && version <= -16777182;
    }

    public boolean isReserved() {
        return this.equals(reserved_1);
    }

    public String getDraftVersion() {
        if (this.versionId > -16777216 && this.versionId <= -16777182) {
            int draft = this.versionId - -16777216;
            return "" + draft;
        }
        return "";
    }

    public int getId() {
        return this.versionId;
    }

    public String toString() {
        Object versionString;
        switch (this.versionId) {
            case 1: {
                versionString = "v1";
                break;
            }
            case 1798521807: {
                versionString = "v2";
                break;
            }
            default: {
                versionString = this.versionId > -16777216 && this.versionId <= -16777182 ? "draft-" + (this.versionId - -16777216) : "v-" + Integer.toHexString(this.versionId);
            }
        }
        return versionString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.versionId == version.versionId;
    }

    public int hashCode() {
        return this.versionId;
    }
}

