/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.cid;

import java.util.Arrays;
import net.luminis.quic.cid.ConnectionIdInfo;
import net.luminis.quic.cid.ConnectionIdRegistry;
import net.luminis.quic.cid.ConnectionIdStatus;
import net.luminis.quic.log.Logger;
import net.luminis.tls.util.ByteUtils;

public class SourceConnectionIdRegistry
extends ConnectionIdRegistry {
    public SourceConnectionIdRegistry(Integer cidLength, Logger logger) {
        super(cidLength, logger);
    }

    public ConnectionIdInfo generateNew() {
        int sequenceNr = (Integer)this.connectionIds.keySet().stream().max(Integer::compareTo).get() + 1;
        ConnectionIdInfo newCid = new ConnectionIdInfo(sequenceNr, this.generateConnectionId(), ConnectionIdStatus.NEW);
        this.connectionIds.put(sequenceNr, newCid);
        return newCid;
    }

    public boolean registerUsedConnectionId(byte[] connectionId) {
        if (!Arrays.equals(this.currentConnectionId, connectionId)) {
            this.connectionIds.values().stream().filter(cid -> Arrays.equals(cid.getConnectionId(), this.currentConnectionId)).forEach(cid -> cid.setStatus(ConnectionIdStatus.USED));
            this.currentConnectionId = connectionId;
            boolean wasNew = this.connectionIds.values().stream().filter(cid -> Arrays.equals(cid.getConnectionId(), this.currentConnectionId)).anyMatch(cid -> cid.getConnectionIdStatus().equals((Object)ConnectionIdStatus.NEW));
            this.connectionIds.values().stream().filter(cid -> Arrays.equals(cid.getConnectionId(), this.currentConnectionId)).forEach(cid -> cid.setStatus(ConnectionIdStatus.IN_USE));
            this.log.info("Peer has switched to connection id " + ByteUtils.bytesToHex((byte[])this.currentConnectionId));
            return wasNew;
        }
        return false;
    }

    public int getMaxSequenceNr() {
        return (Integer)this.connectionIds.keySet().stream().max(Integer::compareTo).get();
    }

    public byte[] get(int sequenceNr) {
        return ((ConnectionIdInfo)this.connectionIds.get(sequenceNr)).getConnectionId();
    }
}

