/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.stream.StreamElement;

public class CryptoFrame
extends QuicFrame
implements StreamElement,
Comparable<StreamElement> {
    private long offset;
    private int length;
    private byte[] cryptoData;
    private byte[] bytes;

    public CryptoFrame() {
    }

    public CryptoFrame(Version quicVersion, byte[] payload) {
        this(quicVersion, 0L, payload);
    }

    public CryptoFrame(Version quicVersion, long offset, byte[] payload) {
        this.offset = offset;
        this.cryptoData = payload;
        this.length = payload.length;
        ByteBuffer frameBuffer = ByteBuffer.allocate(12 + payload.length);
        VariableLengthInteger.encode(6, frameBuffer);
        VariableLengthInteger.encode(offset, frameBuffer);
        VariableLengthInteger.encode(payload.length, frameBuffer);
        frameBuffer.put(payload);
        this.bytes = new byte[frameBuffer.position()];
        frameBuffer.rewind();
        frameBuffer.get(this.bytes);
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.offset) + VariableLengthInteger.bytesNeeded(this.cryptoData.length) + this.cryptoData.length;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)6);
        VariableLengthInteger.encode(this.offset, buffer);
        VariableLengthInteger.encode(this.cryptoData.length, buffer);
        buffer.put(this.cryptoData);
    }

    public CryptoFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        log.debug("Parsing Crypto frame");
        buffer.get();
        this.offset = VariableLengthInteger.parseLong(buffer);
        this.length = VariableLengthInteger.parse(buffer);
        this.cryptoData = new byte[this.length];
        buffer.get(this.cryptoData);
        log.decrypted("Crypto data [" + this.offset + "," + this.length + "]", this.cryptoData);
        return this;
    }

    public String toString() {
        return "CryptoFrame[" + this.offset + "," + this.length + "]";
    }

    @Override
    public byte[] getStreamData() {
        return this.cryptoData;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public long getUpToOffset() {
        return this.offset + (long)this.length;
    }

    @Override
    public int compareTo(StreamElement other) {
        if (this.offset != other.getOffset()) {
            return Long.compare(this.offset, other.getOffset());
        }
        return Long.compare(this.length, other.getLength());
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

