/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class MaxStreamDataFrame
extends QuicFrame {
    private int streamId;
    private long maxData;

    public MaxStreamDataFrame() {
    }

    public MaxStreamDataFrame(int stream, long maxData) {
        this.streamId = stream;
        this.maxData = maxData;
    }

    public MaxStreamDataFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        buffer.get();
        this.streamId = VariableLengthInteger.parse(buffer);
        this.maxData = VariableLengthInteger.parseLong(buffer);
        return this;
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.streamId) + VariableLengthInteger.bytesNeeded(this.maxData);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)17);
        VariableLengthInteger.encode(this.streamId, buffer);
        VariableLengthInteger.encode(this.maxData, buffer);
    }

    public String toString() {
        return "MaxStreamDataFrame[" + this.streamId + ":" + this.maxData + "]";
    }

    public int getStreamId() {
        return this.streamId;
    }

    public long getMaxData() {
        return this.maxData;
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

