/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import net.luminis.quic.log.BaseLogger;

public class FileLogger
extends BaseLogger {
    private File logFile;
    private PrintStream logStream;

    public FileLogger(File logFile) throws IOException {
        this.logFile = logFile;
        this.logStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void log(String message) {
        FileLogger fileLogger = this;
        synchronized (fileLogger) {
            this.logStream.println(message);
            this.logStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void log(String message, Throwable ex) {
        FileLogger fileLogger = this;
        synchronized (fileLogger) {
            this.logStream.println(message);
            ex.printStackTrace(this.logStream);
            this.logStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void logWithHexDump(String message, byte[] data, int length) {
        FileLogger fileLogger = this;
        synchronized (fileLogger) {
            this.logStream.println(message);
            this.logStream.println(this.byteToHexBlock(data, length));
            this.logStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void logWithHexDump(String message, ByteBuffer data, int offset, int length) {
        FileLogger fileLogger = this;
        synchronized (fileLogger) {
            this.logStream.println(message);
            this.logStream.println(this.byteToHexBlock(data, offset, length));
            this.logStream.flush();
        }
    }
}

