/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.packet;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.InvalidPacketException;
import net.luminis.quic.NotYetImplementedException;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.PnSpace;
import net.luminis.quic.QuicRuntimeException;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.Aead;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.tls.util.ByteUtils;

public class RetryPacket
extends QuicPacket {
    private static int V1_type = 3;
    private static int V2_type = 0;
    private static final int RETRY_INTEGRITY_TAG_LENGTH = 16;
    private static final byte[] SECRET_KEY = new byte[]{-52, -50, 24, 126, -48, -102, 9, -48, 87, 40, 21, 90, 108, -71, 107, -31};
    private static final byte[] SECRET_KEY_V1 = new byte[]{-66, 12, 105, 11, -97, 102, 87, 90, 29, 118, 107, 84, -29, 104, -56, 78};
    private static final byte[] SECRET_KEY_V2 = new byte[]{-113, -76, -80, 27, 86, -84, 72, -30, 96, -5, -53, -50, -83, 124, -52, -110};
    private static final byte[] NONCE = new byte[]{-27, 73, 48, -7, 127, 33, 54, -16, 83, 10, -116, 28};
    private static final byte[] NONCE_V1 = new byte[]{70, 21, -103, -45, 93, 99, 43, -14, 35, -104, 37, -69};
    private static final byte[] NONCE_V2 = new byte[]{-40, 105, 105, -68, 45, 124, 109, -103, -112, -17, -80, 74};
    private static int MIN_PACKET_LENGTH = 23;
    private byte[] sourceConnectionId;
    private byte[] originalDestinationConnectionId;
    private byte[] retryToken;
    private byte[] rawPacketData;
    private byte[] retryIntegrityTag;

    public static boolean isRetry(int type, Version quicVersion) {
        if (quicVersion.isV2()) {
            return type == 0;
        }
        return type == 3;
    }

    public RetryPacket(Version quicVersion) {
        this.quicVersion = quicVersion;
    }

    public RetryPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destinationConnectionId, byte[] originalDestinationConnectionId, byte[] retryToken) {
        this.quicVersion = quicVersion;
        this.sourceConnectionId = sourceConnectionId;
        this.destinationConnectionId = destinationConnectionId;
        this.originalDestinationConnectionId = originalDestinationConnectionId;
        this.retryToken = retryToken;
        this.rawPacketData = new byte[6 + destinationConnectionId.length + 1 + sourceConnectionId.length + retryToken.length + 16];
    }

    @Override
    public void parse(ByteBuffer buffer, Aead aead, long largestPacketNumber, Logger log, int sourceConnectionIdLength) throws DecryptionException, InvalidPacketException {
        log.debug("Parsing " + this.getClass().getSimpleName());
        if (buffer.remaining() < MIN_PACKET_LENGTH) {
            throw new InvalidPacketException();
        }
        this.packetSize = buffer.remaining();
        this.rawPacketData = new byte[this.packetSize];
        buffer.mark();
        buffer.get(this.rawPacketData);
        buffer.reset();
        byte flags = buffer.get();
        boolean matchingVersion = Version.parse(buffer.getInt()).equals(this.quicVersion);
        if (!matchingVersion) {
            throw new InvalidPacketException();
        }
        byte dstConnIdLength = buffer.get();
        if (buffer.remaining() < dstConnIdLength + 1 + 16) {
            throw new InvalidPacketException();
        }
        this.destinationConnectionId = new byte[dstConnIdLength];
        buffer.get(this.destinationConnectionId);
        byte srcConnIdLength = buffer.get();
        if (buffer.remaining() < srcConnIdLength) {
            throw new InvalidPacketException();
        }
        this.sourceConnectionId = new byte[srcConnIdLength];
        buffer.get(this.sourceConnectionId);
        log.debug("Destination connection id", this.destinationConnectionId);
        log.debug("Source connection id", this.sourceConnectionId);
        if (buffer.remaining() < 16) {
            throw new InvalidPacketException();
        }
        int retryTokenLength = buffer.remaining() - 16;
        this.retryToken = new byte[retryTokenLength];
        buffer.get(this.retryToken);
        this.retryIntegrityTag = new byte[16];
        buffer.get(this.retryIntegrityTag);
    }

    public boolean validateIntegrityTag(byte[] originalDestinationConnectionId) {
        return Arrays.equals(this.computeIntegrityTag(originalDestinationConnectionId), this.retryIntegrityTag);
    }

    @Override
    public EncryptionLevel getEncryptionLevel() {
        return EncryptionLevel.Initial;
    }

    @Override
    public PnSpace getPnSpace() {
        return null;
    }

    @Override
    public Long getPacketNumber() {
        return null;
    }

    @Override
    public int estimateLength(int additionalPayload) {
        throw new NotYetImplementedException();
    }

    @Override
    public PacketProcessor.ProcessResult accept(PacketProcessor processor, Instant time) {
        return processor.process(this, time);
    }

    @Override
    public byte[] generatePacketBytes(Aead aead) {
        this.packetSize = 6 + this.destinationConnectionId.length + 1 + this.sourceConnectionId.length + this.retryToken.length + 16;
        ByteBuffer buffer = ByteBuffer.allocate(this.packetSize);
        byte flags = (byte)(0xC0 | this.getPacketType() << 4);
        buffer.put(flags);
        buffer.put(this.quicVersion.getBytes());
        buffer.put((byte)this.destinationConnectionId.length);
        buffer.put(this.destinationConnectionId);
        buffer.put((byte)this.sourceConnectionId.length);
        buffer.put(this.sourceConnectionId);
        buffer.put(this.retryToken);
        this.rawPacketData = buffer.array();
        buffer.put(this.computeIntegrityTag(this.originalDestinationConnectionId));
        return buffer.array();
    }

    private int getPacketType() {
        if (this.quicVersion.isV2()) {
            return (byte)V2_type;
        }
        return (byte)V1_type;
    }

    private byte[] computeIntegrityTag(byte[] originalDestinationConnectionId) {
        ByteBuffer pseudoPacket = ByteBuffer.allocate(1 + originalDestinationConnectionId.length + 1 + 4 + 1 + this.destinationConnectionId.length + 1 + this.sourceConnectionId.length + this.retryToken.length);
        pseudoPacket.put((byte)originalDestinationConnectionId.length);
        pseudoPacket.put(originalDestinationConnectionId);
        pseudoPacket.put(this.rawPacketData, 0, this.rawPacketData.length - 16);
        try {
            SecretKeySpec secretKey = new SecretKeySpec(this.quicVersion.isV1() ? SECRET_KEY_V1 : (this.quicVersion.isV2() ? SECRET_KEY_V2 : SECRET_KEY), "AES");
            String AES_GCM_NOPADDING = "AES/GCM/NoPadding";
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, this.quicVersion.isV1() ? NONCE_V1 : (this.quicVersion.isV2() ? NONCE_V2 : NONCE));
            Cipher aeadCipher = Cipher.getInstance(AES_GCM_NOPADDING);
            aeadCipher.init(1, (Key)secretKey, parameterSpec);
            aeadCipher.updateAAD(pseudoPacket.array());
            byte[] cipherText = aeadCipher.doFinal(new byte[0]);
            return cipherText;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new QuicRuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public boolean canBeAcked() {
        return false;
    }

    @Override
    public boolean isInflightPacket() {
        return false;
    }

    @Override
    public boolean isAckEliciting() {
        return false;
    }

    @Override
    public boolean isAckOnly() {
        return false;
    }

    public byte[] getRetryToken() {
        return this.retryToken;
    }

    public byte[] getSourceConnectionId() {
        return this.sourceConnectionId;
    }

    public String toString() {
        return "Packet " + this.getEncryptionLevel().name().charAt(0) + "|-|R|" + this.packetSize + "| Retry Token (" + this.retryToken.length + "): " + ByteUtils.bytesToHex((byte[])this.retryToken);
    }
}

