/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.send;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.luminis.quic.AckGenerator;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.GlobalAckGenerator;
import net.luminis.quic.PnSpace;
import net.luminis.quic.VersionHolder;
import net.luminis.quic.frame.Padding;
import net.luminis.quic.frame.PathChallengeFrame;
import net.luminis.quic.frame.PathResponseFrame;
import net.luminis.quic.packet.InitialPacket;
import net.luminis.quic.send.InitialPacketAssembler;
import net.luminis.quic.send.NullAckGenerator;
import net.luminis.quic.send.PacketAssembler;
import net.luminis.quic.send.PacketNumberGenerator;
import net.luminis.quic.send.SendItem;
import net.luminis.quic.send.SendRequestQueue;

public class GlobalPacketAssembler {
    private SendRequestQueue[] sendRequestQueue;
    private volatile PacketAssembler[] packetAssembler = new PacketAssembler[EncryptionLevel.values().length];
    private volatile EncryptionLevel[] enabledLevels;

    public GlobalPacketAssembler(VersionHolder quicVersion, SendRequestQueue[] sendRequestQueues, GlobalAckGenerator globalAckGenerator) {
        this.sendRequestQueue = sendRequestQueues;
        PacketNumberGenerator appSpacePnGenerator = new PacketNumberGenerator();
        Arrays.stream(EncryptionLevel.values()).forEach(level -> {
            int levelIndex = level.ordinal();
            AckGenerator ackGenerator = level != EncryptionLevel.ZeroRTT ? globalAckGenerator.getAckGenerator(level.relatedPnSpace()) : new NullAckGenerator();
            switch (level) {
                case ZeroRTT: 
                case App: {
                    this.packetAssembler[levelIndex] = new PacketAssembler(quicVersion, (EncryptionLevel)((Object)level), this.sendRequestQueue[levelIndex], ackGenerator, appSpacePnGenerator);
                    break;
                }
                case Initial: {
                    this.packetAssembler[levelIndex] = new InitialPacketAssembler(quicVersion, this.sendRequestQueue[levelIndex], ackGenerator);
                    break;
                }
                default: {
                    this.packetAssembler[levelIndex] = new PacketAssembler(quicVersion, (EncryptionLevel)((Object)level), this.sendRequestQueue[levelIndex], ackGenerator);
                }
            }
        });
        this.enabledLevels = new EncryptionLevel[]{EncryptionLevel.Initial, EncryptionLevel.ZeroRTT, EncryptionLevel.Handshake};
    }

    public List<SendItem> assemble(int remainingCwndSize, int maxDatagramSize, byte[] sourceConnectionId, byte[] destinationConnectionId) {
        ArrayList<SendItem> packets = new ArrayList<SendItem>();
        int size = 0;
        boolean hasInitial = false;
        boolean hasPathChallengeOrResponse = false;
        int minPacketSize = 19 + destinationConnectionId.length;
        int remaining = Integer.min(remainingCwndSize, maxDatagramSize);
        for (EncryptionLevel level : this.enabledLevels) {
            PacketAssembler assembler = this.packetAssembler[level.ordinal()];
            if (assembler == null) continue;
            Optional<SendItem> item2 = assembler.assemble(remaining, maxDatagramSize - size, sourceConnectionId, destinationConnectionId);
            if (item2.isPresent()) {
                packets.add(item2.get());
                int packetSize = item2.get().getPacket().estimateLength(0);
                size += packetSize;
                remaining -= packetSize;
                if (level == EncryptionLevel.Initial) {
                    hasInitial = true;
                }
                if (item2.get().getPacket().getFrames().stream().anyMatch(f -> f instanceof PathChallengeFrame || f instanceof PathResponseFrame)) {
                    hasPathChallengeOrResponse = true;
                }
            }
            if (remaining < minPacketSize && maxDatagramSize - size < minPacketSize) break;
        }
        if (hasInitial && size < 1200) {
            int requiredPadding = 1200 - size;
            packets.stream().map(item -> item.getPacket()).filter(p -> p instanceof InitialPacket).findFirst().ifPresent(initial -> initial.addFrame(new Padding(requiredPadding)));
            size += requiredPadding;
        }
        if (hasPathChallengeOrResponse && size < 1200) {
            int requiredPadding = 1200 - size;
            packets.stream().map(item -> item.getPacket()).findFirst().ifPresent(packet -> packet.addFrame(new Padding(requiredPadding)));
            size += requiredPadding;
        }
        return packets;
    }

    public Optional<Instant> nextDelayedSendTime() {
        return Arrays.stream(this.enabledLevels).map(level -> this.sendRequestQueue[level.ordinal()]).map(q -> q.nextDelayedSend()).filter(Objects::nonNull).findFirst();
    }

    public void stop(PnSpace pnSpace) {
        this.packetAssembler[pnSpace.relatedEncryptionLevel().ordinal()].stop((PacketAssembler assembler) -> {
            this.packetAssembler[pnSpace.relatedEncryptionLevel().ordinal()] = null;
        });
    }

    public void setInitialToken(byte[] token) {
        ((InitialPacketAssembler)this.packetAssembler[EncryptionLevel.Initial.ordinal()]).setInitialToken(token);
    }

    public void enableAppLevel() {
        this.enabledLevels = EncryptionLevel.values();
    }
}

