/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.server;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.server.ApplicationProtocolConnection;
import net.luminis.quic.server.ApplicationProtocolConnectionFactory;

public class ApplicationProtocolRegistry {
    Map<String, ApplicationProtocolConnectionFactory> registeredFactories = new LinkedHashMap<String, ApplicationProtocolConnectionFactory>();

    Optional<String> selectSupportedApplicationProtocol(List<String> clientProtocols) {
        LinkedHashSet<String> intersection = new LinkedHashSet<String>(this.registeredFactories.keySet());
        intersection.retainAll(clientProtocols);
        return intersection.stream().findFirst();
    }

    ApplicationProtocolConnection startApplicationProtocolConnection(String protocol, QuicConnection quicConnection) {
        ApplicationProtocolConnection applicationProtocolConnection = this.registeredFactories.get(protocol).createConnection(protocol, quicConnection);
        quicConnection.setPeerInitiatedStreamCallback(applicationProtocolConnection::acceptPeerInitiatedStream);
        return applicationProtocolConnection;
    }

    void registerApplicationProtocol(String protocol, ApplicationProtocolConnectionFactory factory) {
        this.registeredFactories.put(protocol, factory);
    }

    Set<String> getRegisteredApplicationProtocols() {
        return this.registeredFactories.keySet();
    }
}

