/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import net.luminis.quic.PnSpace;
import net.luminis.quic.Version;
import net.luminis.quic.ack.Range;
import net.luminis.quic.frame.AckFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.send.Sender;

public class AckGenerator {
    private final Clock clock;
    private final Version quicVersion = Version.getDefault();
    private final PnSpace pnSpace;
    private final Sender sender;
    private List<Range> rangesToAcknowledge = new ArrayList<Range>();
    private boolean newPacketsToAcknowledge;
    private Instant newPacketsToAcknowlegdeSince;
    private Map<Long, AckFrame> ackSentWithPacket = new HashMap<Long, AckFrame>();
    private int acksNotSend = 0;

    public AckGenerator(PnSpace pnSpace, Sender sender) {
        this(Clock.systemUTC(), pnSpace, sender);
    }

    public AckGenerator(Clock clock, PnSpace pnSpace, Sender sender) {
        this.clock = clock;
        this.pnSpace = pnSpace;
        this.sender = sender;
    }

    public synchronized boolean hasAckToSend() {
        return !this.rangesToAcknowledge.isEmpty();
    }

    public synchronized boolean hasNewAckToSend() {
        return this.newPacketsToAcknowledge;
    }

    public synchronized void packetReceived(QuicPacket packet) {
        if (packet.canBeAcked()) {
            Range.extendRangeList(this.rangesToAcknowledge, packet.getPacketNumber());
            if (packet.isAckEliciting()) {
                this.newPacketsToAcknowledge = true;
                if (this.newPacketsToAcknowlegdeSince == null) {
                    this.newPacketsToAcknowlegdeSince = this.clock.instant();
                }
                if (this.pnSpace != PnSpace.App) {
                    this.sender.sendAck(this.pnSpace, 0);
                } else {
                    int ackFrequency = 2;
                    ++this.acksNotSend;
                    if (this.acksNotSend >= ackFrequency) {
                        this.sender.sendAck(this.pnSpace, 0);
                        this.acksNotSend = 0;
                    } else {
                        this.sender.sendAck(this.pnSpace, 20);
                    }
                }
            }
        }
    }

    public synchronized void process(QuicFrame receivedAck) {
        Optional<Long> largestWithAck = ((AckFrame)receivedAck).getAckedPacketNumbers().filter(pn -> this.ackSentWithPacket.containsKey(pn)).findFirst();
        if (largestWithAck.isPresent()) {
            AckFrame latestAcknowledgedAck = this.ackSentWithPacket.get(largestWithAck.get());
            this.removeAcknowlegdedRanges(this.rangesToAcknowledge, latestAcknowledgedAck);
            this.ackSentWithPacket.keySet().removeIf(key -> key <= (Long)largestWithAck.get());
        }
    }

    void removeAcknowlegdedRanges(List<Range> rangesToAcknowledge, AckFrame ack) {
        if (rangesToAcknowledge.isEmpty()) {
            return;
        }
        ListIterator<Range> rangeListIterator = rangesToAcknowledge.listIterator();
        ListIterator<Range> ackRangesIterator = ack.getAcknowledgedRanges().listIterator();
        Range currentListRange = rangeListIterator.next();
        while (ackRangesIterator.hasNext()) {
            Range currentAckRange = ackRangesIterator.next();
            while (currentListRange.greaterThan(currentAckRange)) {
                if (rangeListIterator.hasNext()) {
                    currentListRange = rangeListIterator.next();
                    continue;
                }
                return;
            }
            if (currentListRange.lessThan(currentAckRange)) continue;
            if (currentAckRange.contains(currentListRange)) {
                rangeListIterator.remove();
                continue;
            }
            if (currentListRange.properlyContains(currentAckRange)) continue;
            rangeListIterator.set(currentListRange.subtract(currentAckRange));
        }
    }

    public synchronized Optional<AckFrame> generateAckForPacket(long packetNumber) {
        Optional<AckFrame> ackFrame = this.generateAck();
        if (ackFrame.isPresent()) {
            this.registerAckSendWithPacket(ackFrame.get(), packetNumber);
        }
        return ackFrame;
    }

    public synchronized Optional<AckFrame> generateAck() {
        int delay = 0;
        if (this.newPacketsToAcknowlegdeSince != null && this.pnSpace == PnSpace.App && (delay = (int)Duration.between(this.newPacketsToAcknowlegdeSince, this.clock.instant()).toMillis()) < 0) {
            delay = 0;
        }
        if (!this.rangesToAcknowledge.isEmpty()) {
            return Optional.of(new AckFrame(this.quicVersion, this.rangesToAcknowledge, delay));
        }
        return Optional.empty();
    }

    public synchronized void registerAckSendWithPacket(AckFrame ackFrame, long packetNumber) {
        this.ackSentWithPacket.put(packetNumber, ackFrame);
        this.newPacketsToAcknowledge = false;
        this.newPacketsToAcknowlegdeSince = null;
        this.acksNotSend = 0;
    }
}

