/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import net.luminis.quic.QuicConnectionImpl;
import net.luminis.quic.concurrent.DaemonThreadFactory;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class IdleTimer {
    private final Clock clock;
    private final ScheduledExecutorService timer;
    private final int timerResolution;
    private volatile long timeout;
    private final QuicConnectionImpl connection;
    private final Logger log;
    private volatile IntSupplier ptoSupplier;
    private volatile Instant lastAction;
    private volatile boolean enabled;
    private ScheduledFuture<?> timerTask;

    public IdleTimer(QuicConnectionImpl connection, Logger logger) {
        this(connection, logger, 1000);
    }

    public IdleTimer(QuicConnectionImpl connection, Logger logger, int timerResolution) {
        this(Clock.systemUTC(), connection, logger, timerResolution);
    }

    public IdleTimer(Clock clock, QuicConnectionImpl connection, Logger logger, int timerResolution) {
        this.clock = clock;
        this.connection = connection;
        this.ptoSupplier = () -> 0;
        this.log = logger;
        this.timerResolution = timerResolution;
        this.timer = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("idle-timer"));
        this.lastAction = clock.instant();
    }

    void setIdleTimeout(long idleTimeoutInMillis) {
        this.timeout = idleTimeoutInMillis;
        if (!this.enabled) {
            this.enabled = true;
        } else {
            this.timerTask.cancel(true);
        }
        this.timerTask = this.timer.scheduleAtFixedRate(() -> this.checkIdle(), this.timerResolution, this.timerResolution, TimeUnit.MILLISECONDS);
    }

    long getIdleTimeout() {
        return this.timeout;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    public void setPtoSupplier(IntSupplier ptoSupplier) {
        this.ptoSupplier = ptoSupplier;
    }

    private void checkIdle() {
        if (this.enabled) {
            int currentPto;
            Instant now = this.clock.instant();
            if (this.lastAction.plusMillis(this.timeout).isBefore(now) && this.lastAction.plusMillis(3 * (currentPto = this.ptoSupplier.getAsInt())).isBefore(now)) {
                this.timer.shutdown();
                this.connection.silentlyCloseConnection(this.timeout + (long)currentPto);
            }
        }
    }

    public void packetProcessed() {
        if (this.enabled) {
            this.lastAction = this.clock.instant();
        }
    }

    public void packetSent(QuicPacket packet, Instant sendTime) {
        if (this.enabled && packet.isAckEliciting()) {
            this.lastAction = sendTime;
        }
    }

    public void shutdown() {
        if (this.enabled) {
            this.timer.shutdown();
        }
    }
}

