/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.nio.ByteBuffer;
import java.util.Date;
import net.luminis.quic.TransportParameters;
import net.luminis.tls.NewSessionTicket;

public class QuicSessionTicket
extends NewSessionTicket {
    private static final int SERIALIZED_SIZE = 69;
    private NewSessionTicket wrappedTicket;
    private long maxIdleTimeout;
    private int maxPacketSize;
    private long initialMaxData;
    private long initialMaxStreamDataBidiLocal;
    private long initialMaxStreamDataBidiRemote;
    private long initialMaxStreamDataUni;
    private long initialMaxStreamsBidi;
    private long initialMaxStreamsUni;
    private boolean disableActiveMigration;
    private int activeConnectionIdLimit;

    QuicSessionTicket(NewSessionTicket tlsTicket, TransportParameters serverParameters) {
        this.wrappedTicket = tlsTicket;
        this.maxIdleTimeout = serverParameters.getMaxIdleTimeout();
        this.maxPacketSize = serverParameters.getMaxUdpPayloadSize();
        this.initialMaxData = serverParameters.getInitialMaxData();
        this.initialMaxStreamDataBidiLocal = serverParameters.getInitialMaxStreamDataBidiLocal();
        this.initialMaxStreamDataBidiRemote = serverParameters.getInitialMaxStreamDataBidiRemote();
        this.initialMaxStreamDataUni = serverParameters.getInitialMaxStreamDataUni();
        this.initialMaxStreamsBidi = serverParameters.getInitialMaxStreamsBidi();
        this.initialMaxStreamsUni = serverParameters.getInitialMaxStreamsUni();
        this.disableActiveMigration = serverParameters.getDisableMigration();
        this.activeConnectionIdLimit = serverParameters.getActiveConnectionIdLimit();
    }

    public QuicSessionTicket(byte[] data) {
        super(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, data.length - 69, 69);
        this.wrappedTicket = this;
        this.maxIdleTimeout = buffer.getLong();
        this.maxPacketSize = buffer.getInt();
        this.initialMaxData = buffer.getLong();
        this.initialMaxStreamDataBidiLocal = buffer.getLong();
        this.initialMaxStreamDataBidiRemote = buffer.getLong();
        this.initialMaxStreamDataUni = buffer.getLong();
        this.initialMaxStreamsBidi = buffer.getLong();
        this.initialMaxStreamsUni = buffer.getLong();
        this.disableActiveMigration = buffer.get() == 1;
        this.activeConnectionIdLimit = buffer.getInt();
    }

    public byte[] serialize() {
        byte[] serializedTicket = this.wrappedTicket != this ? this.wrappedTicket.serialize() : super.serialize();
        ByteBuffer buffer = ByteBuffer.allocate(serializedTicket.length + 69);
        buffer.put(serializedTicket);
        buffer.putLong(this.maxIdleTimeout);
        buffer.putInt(this.maxPacketSize);
        buffer.putLong(this.initialMaxData);
        buffer.putLong(this.initialMaxStreamDataBidiLocal);
        buffer.putLong(this.initialMaxStreamDataBidiRemote);
        buffer.putLong(this.initialMaxStreamDataUni);
        buffer.putLong(this.initialMaxStreamsBidi);
        buffer.putLong(this.initialMaxStreamsUni);
        buffer.put((byte)(this.disableActiveMigration ? 1 : 0));
        buffer.putInt(this.activeConnectionIdLimit);
        return buffer.array();
    }

    public byte[] getPSK() {
        if (this.wrappedTicket != this) {
            return this.wrappedTicket.getPSK();
        }
        return super.getPSK();
    }

    public Date getTicketCreationDate() {
        if (this.wrappedTicket != this) {
            return this.wrappedTicket.getTicketCreationDate();
        }
        return super.getTicketCreationDate();
    }

    public long getTicketAgeAdd() {
        if (this.wrappedTicket != this) {
            return this.wrappedTicket.getTicketAgeAdd();
        }
        return super.getTicketAgeAdd();
    }

    public byte[] getSessionTicketIdentity() {
        if (this.wrappedTicket != this) {
            return this.wrappedTicket.getSessionTicketIdentity();
        }
        return super.getSessionTicketIdentity();
    }

    public void copyTo(TransportParameters tp) {
        tp.setMaxIdleTimeout(this.maxIdleTimeout);
        tp.setMaxUdpPayloadSize(this.maxPacketSize);
        tp.setInitialMaxData(this.initialMaxData);
        tp.setInitialMaxStreamDataBidiLocal(this.initialMaxStreamDataBidiLocal);
        tp.setInitialMaxStreamDataBidiRemote(this.initialMaxStreamDataBidiRemote);
        tp.setInitialMaxStreamDataUni(this.initialMaxStreamDataUni);
        tp.setInitialMaxStreamsBidi(this.initialMaxStreamsBidi);
        tp.setInitialMaxStreamsUni(this.initialMaxStreamsUni);
        tp.setDisableMigration(this.disableActiveMigration);
        tp.setActiveConnectionIdLimit(this.activeConnectionIdLimit);
    }

    public static QuicSessionTicket deserialize(byte[] data) {
        return new QuicSessionTicket(data);
    }

    public long getMaxIdleTimeout() {
        return this.maxIdleTimeout;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public long getInitialMaxData() {
        return this.initialMaxData;
    }

    public long getInitialMaxStreamDataBidiLocal() {
        return this.initialMaxStreamDataBidiLocal;
    }

    public long getInitialMaxStreamDataBidiRemote() {
        return this.initialMaxStreamDataBidiRemote;
    }

    public long getInitialMaxStreamDataUni() {
        return this.initialMaxStreamDataUni;
    }

    public long getInitialMaxStreamsBidi() {
        return this.initialMaxStreamsBidi;
    }

    public long getInitialMaxStreamsUni() {
        return this.initialMaxStreamsUni;
    }

    public boolean getDisableActiveMigration() {
        return this.disableActiveMigration;
    }

    public int getActiveConnectionIdLimit() {
        return this.activeConnectionIdLimit;
    }
}

