/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.ack;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Range {
    private final long from;
    private final long to;

    public Range(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException();
        }
        this.from = from;
        this.to = to;
    }

    public Range(long fromTo) {
        this.from = fromTo;
        this.to = fromTo;
    }

    public Range(int from, int to) {
        this((long)from, (long)to);
    }

    public static boolean validRangeList(List<Range> ackRanges) {
        Iterator<Range> iterator = ackRanges.iterator();
        long previousSmallest = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            Range next = iterator.next();
            if (next.to >= previousSmallest - 1L) {
                return false;
            }
            previousSmallest = next.from;
        }
        return true;
    }

    public boolean canBeExtendedWith(long number) {
        return number == this.from - 1L || number == this.to + 1L;
    }

    public boolean contains(long number) {
        return number >= this.from && number <= this.to;
    }

    public Range extendWith(long number) {
        if (number == this.to + 1L) {
            return new Range(this.from, this.to + 1L);
        }
        if (number == this.from - 1L) {
            return new Range(this.from - 1L, this.to);
        }
        throw new IllegalArgumentException("Range cannot be extended with that number " + number);
    }

    public Range extendWith(long number, Range next) {
        if (number == next.to + 1L && this.from - 1L == number) {
            return new Range(next.from, this.to);
        }
        if (this.to + 1L == number && number == next.from - 1L) {
            return new Range(this.from, next.to);
        }
        throw new IllegalArgumentException();
    }

    public Range subtract(Range other) {
        assert (!this.equals(other));
        if (this.equals(other)) {
            throw new IllegalArgumentException();
        }
        assert (!this.properlyContains(other));
        if (this.properlyContains(other)) {
            throw new IllegalArgumentException();
        }
        assert (!other.properlyContains(this));
        if (other.properlyContains(this)) {
            throw new IllegalArgumentException();
        }
        if (this.from > other.to || this.to < other.from) {
            return this;
        }
        if (this.from < other.from && this.to == other.to) {
            return new Range(this.from, other.from - 1L);
        }
        if (this.from > other.from && this.to > other.to) {
            return new Range(other.to + 1L, this.to);
        }
        if (this.from == other.from && this.to > other.to) {
            return new Range(other.to + 1L, this.to);
        }
        if (this.from < other.from && this.to < other.to) {
            return new Range(this.from, other.from - 1L);
        }
        throw new IllegalStateException();
    }

    public static boolean extendRangeList(List<Range> ranges, long number) {
        int index = 0;
        Iterator<Range> iterator = ranges.iterator();
        while (iterator.hasNext()) {
            Range current = iterator.next();
            if (current.contains(number)) {
                return false;
            }
            if (current.canBeExtendedWith(number)) {
                Range next = null;
                if (iterator.hasNext()) {
                    next = iterator.next();
                }
                if (next != null && next.canBeExtendedWith(number)) {
                    ranges.set(index, ranges.get(index).extendWith(number, next));
                    ranges.remove(index + 1);
                    return true;
                }
                ranges.set(index, ranges.get(index).extendWith(number));
                return true;
            }
            if (current.to < number) {
                ranges.add(index, new Range(number));
                return true;
            }
            ++index;
        }
        ranges.add(index, new Range(number));
        return true;
    }

    public boolean greaterThan(Range other) {
        return this.from > other.to;
    }

    public boolean lessThan(Range other) {
        return this.to < other.from;
    }

    public boolean contains(Range other) {
        return this.from <= other.from && this.to >= other.to;
    }

    public boolean properlyContains(Range other) {
        return this.from < other.from && this.to > other.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.from, range.from) && Objects.equals(this.to, range.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public String toString() {
        return "[" + this.to + ".." + this.from + "]";
    }

    public int size() {
        return (int)(this.to - this.from + 1L);
    }

    public long getLargest() {
        return this.to;
    }

    public long getSmallest() {
        return this.from;
    }

    public Stream<Long> stream() {
        return Stream.generate(new StreamElementGenerator()).limit(this.size());
    }

    private class StreamElementGenerator
    implements Supplier<Long> {
        private long next;

        private StreamElementGenerator() {
            this.next = Range.this.to;
        }

        @Override
        public Long get() {
            return this.next--;
        }
    }
}

