/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.cc;

import java.time.Instant;
import java.util.List;
import java.util.stream.Stream;
import net.luminis.quic.cc.AbstractCongestionController;
import net.luminis.quic.cc.CongestionControlEventListener;
import net.luminis.quic.cc.CongestionController;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.PacketInfo;
import net.luminis.quic.packet.QuicPacket;

public class NewRenoCongestionController
extends AbstractCongestionController
implements CongestionController {
    protected int kLossReductionFactor = 2;
    protected int kMinimumWindow = 2400;
    protected int kMaxDatagramSize = 1200;
    private long slowStartThreshold = Long.MAX_VALUE;
    private Instant congestionRecoveryStartTime = Instant.MIN;

    public NewRenoCongestionController(Logger logger, CongestionControlEventListener eventListener) {
        super(logger, eventListener);
    }

    @Override
    public synchronized void registerInFlight(QuicPacket sentPacket) {
        super.registerInFlight(sentPacket);
        this.log.getQLog().emitCongestionControlMetrics(this.congestionWindow, this.bytesInFlight);
    }

    @Override
    public synchronized void registerAcked(List<? extends PacketInfo> acknowlegdedPackets) {
        int epsilon = 3;
        boolean cwndLimited = this.congestionWindow - this.bytesInFlight <= (long)epsilon;
        long bytesInFlightBefore = this.bytesInFlight;
        super.registerAcked(acknowlegdedPackets);
        Stream<QuicPacket> notBeforeRecovery = acknowlegdedPackets.stream().filter(ackedPacket -> ackedPacket.timeSent().isAfter(this.congestionRecoveryStartTime)).map(ackedPacket -> ackedPacket.packet());
        if (cwndLimited) {
            long previousCwnd = this.congestionWindow;
            notBeforeRecovery.forEach(p -> {
                this.congestionWindow = this.congestionWindow < this.slowStartThreshold ? (this.congestionWindow += (long)p.getSize()) : (this.congestionWindow += (long)(this.kMaxDatagramSize * p.getSize()) / this.congestionWindow);
            });
            if (this.congestionWindow != previousCwnd) {
                this.log.cc("Cwnd(+): " + this.congestionWindow + " (" + this.getMode() + "); inflight: " + bytesInFlightBefore);
            }
        }
        this.log.getQLog().emitCongestionControlMetrics(this.congestionWindow, this.bytesInFlight);
    }

    @Override
    public void registerLost(List<? extends PacketInfo> lostPackets) {
        super.registerLost(lostPackets);
        if (!lostPackets.isEmpty()) {
            PacketInfo largest = (PacketInfo)lostPackets.stream().max((p1, p2) -> p1.packet().getPacketNumber().compareTo(p2.packet().getPacketNumber())).get();
            this.fireCongestionEvent(largest.timeSent());
        }
        this.log.getQLog().emitCongestionControlMetrics(this.congestionWindow, this.bytesInFlight);
    }

    private void fireCongestionEvent(Instant timeSent) {
        if (timeSent.isAfter(this.congestionRecoveryStartTime)) {
            this.congestionRecoveryStartTime = Instant.now();
            this.congestionWindow /= (long)this.kLossReductionFactor;
            if (this.congestionWindow < (long)this.kMinimumWindow) {
                this.congestionWindow = this.kMinimumWindow;
            }
            this.log.cc("Cwnd(-): " + this.congestionWindow + "; inflight: " + this.bytesInFlight);
            this.slowStartThreshold = this.congestionWindow;
        }
    }

    public Mode getMode() {
        if (this.congestionWindow < this.slowStartThreshold) {
            return Mode.SlowStart;
        }
        return Mode.CongestionAvoidance;
    }

    public static enum Mode {
        SlowStart,
        CongestionAvoidance;

    }
}

