/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.client.h09;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicStream;
import net.luminis.quic.client.h09.HttpResponseImpl;
import net.luminis.quic.concurrent.DaemonThreadFactory;

public class Http09Client
extends HttpClient {
    private final QuicClientConnection quicConnection;
    private final boolean with0RTT;
    private final int connectionTimeout = 10000;
    private final ExecutorService executorService;

    public Http09Client(QuicClientConnection quicConnection, boolean with0RTT) {
        this.quicConnection = quicConnection;
        this.with0RTT = with0RTT;
        this.executorService = Executors.newCachedThreadPool(new DaemonThreadFactory("http09"));
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return Optional.empty();
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return Optional.empty();
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return null;
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return Optional.empty();
    }

    @Override
    public SSLContext sslContext() {
        return null;
    }

    @Override
    public SSLParameters sslParameters() {
        return null;
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return Optional.empty();
    }

    @Override
    public HttpClient.Version version() {
        return null;
    }

    @Override
    public Optional<Executor> executor() {
        return Optional.empty();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        AsyncHttpRequest<T> requestTask = new AsyncHttpRequest<T>(request, responseBodyHandler);
        requestTask.run();
        try {
            return (HttpResponse)requestTask.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        AsyncHttpRequest<T> future = new AsyncHttpRequest<T>(request, responseBodyHandler);
        future.start();
        return future;
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        throw new UnsupportedOperationException();
    }

    private class AsyncHttpRequest<T>
    extends CompletableFuture<HttpResponse<T>> {
        private final HttpRequest request;
        private final HttpResponse.BodyHandler<T> responseBodyHandler;
        private QuicStream httpStream;

        public AsyncHttpRequest(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
            this.request = request;
            this.responseBodyHandler = responseBodyHandler;
        }

        public void start() {
            Http09Client.this.executorService.submit(() -> this.run());
        }

        public void run() {
            try {
                this.complete(this.send(this.request, this.responseBodyHandler));
            }
            catch (IOException | InterruptedException | RuntimeException ex) {
                this.completeExceptionally(ex);
            }
            catch (Exception ex) {
                this.completeExceptionally(ex);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.httpStream.closeInput(9L);
            return super.cancel(mayInterruptIfRunning);
        }

        private <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
            String requestPath = request.uri().getPath();
            String httpGetCommand = "GET " + requestPath + "\r\n";
            this.httpStream = null;
            if (!Http09Client.this.quicConnection.isConnected()) {
                Object alpn;
                if (Http09Client.this.quicConnection.getQuicVersion().isV1V2()) {
                    alpn = "hq-interop";
                } else {
                    String draftVersion = Http09Client.this.quicConnection.getQuicVersion().getDraftVersion();
                    alpn = "hq-" + draftVersion;
                }
                if (Http09Client.this.with0RTT) {
                    QuicClientConnection.StreamEarlyData earlyData = new QuicClientConnection.StreamEarlyData(httpGetCommand.getBytes(), true);
                    this.httpStream = Http09Client.this.quicConnection.connect(10000, (String)alpn, null, List.of(earlyData)).get(0);
                } else {
                    Http09Client.this.quicConnection.connect(10000, (String)alpn, null, null);
                }
            }
            if (this.httpStream == null) {
                boolean bidirectional = true;
                this.httpStream = Http09Client.this.quicConnection.createStream(bidirectional);
                this.httpStream.getOutputStream().write(httpGetCommand.getBytes());
                this.httpStream.getOutputStream().close();
            }
            HttpResponse.BodySubscriber<List<ByteBuffer>> bodySubscriber = responseBodyHandler.apply(new HttpResponse.ResponseInfo(){

                @Override
                public int statusCode() {
                    return 200;
                }

                @Override
                public HttpHeaders headers() {
                    return HttpHeaders.of(Collections.emptyMap(), (u, v) -> true);
                }

                @Override
                public HttpClient.Version version() {
                    return null;
                }
            });
            bodySubscriber.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long n) {
                }

                @Override
                public void cancel() {
                }
            });
            InputStream inputStream = this.httpStream.getInputStream();
            while (true) {
                byte[] buffer;
                int read;
                int available;
                if ((available = inputStream.available()) == 0) {
                    available = 1;
                }
                if ((read = inputStream.read(buffer = new byte[available])) < 0) break;
                bodySubscriber.onNext(List.of(ByteBuffer.wrap(buffer, 0, read)));
            }
            bodySubscriber.onComplete();
            try {
                T body = bodySubscriber.getBody().toCompletableFuture().get();
                return new HttpResponseImpl<T>(request, body);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
    }
}

