/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.crypto;

import at.favre.lib.crypto.HKDF;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.QuicRuntimeException;
import net.luminis.quic.Role;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.BaseAeadImpl;
import net.luminis.quic.log.Logger;

public class Aes128Gcm
extends BaseAeadImpl {
    public Aes128Gcm(Version quicVersion, Role nodeRole, Logger log) {
        super(quicVersion, nodeRole, log);
    }

    public Aes128Gcm(Version quicVersion, byte[] initialSecret, Role nodeRole, Logger log) {
        super(quicVersion, initialSecret, nodeRole, log);
    }

    @Override
    protected short getKeyLength() {
        return 16;
    }

    @Override
    protected short getHashLength() {
        return 32;
    }

    @Override
    protected HKDF getHKDF() {
        return HKDF.fromHmacSha256();
    }

    @Override
    public Cipher getHeaderProtectionCipher() {
        if (this.hpCipher == null) {
            try {
                this.hpCipher = Cipher.getInstance("AES/ECB/NoPadding");
                SecretKeySpec keySpec = new SecretKeySpec(this.getHp(), "AES");
                this.hpCipher.init(1, keySpec);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new QuicRuntimeException(e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException();
            }
        }
        return this.hpCipher;
    }

    @Override
    public byte[] createHeaderProtectionMask(byte[] sample) {
        byte[] mask;
        Cipher hpCipher = this.getHeaderProtectionCipher();
        try {
            mask = hpCipher.doFinal(sample);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException();
        }
        return mask;
    }

    @Override
    public SecretKeySpec getWriteKeySpec() {
        if (this.possibleKeyUpdateInProgresss) {
            if (this.newWriteKeySpec == null) {
                this.newWriteKeySpec = new SecretKeySpec(this.newKey, "AES");
            }
            return this.newWriteKeySpec;
        }
        if (this.writeKeySpec == null) {
            this.writeKeySpec = new SecretKeySpec(this.writeKey, "AES");
        }
        return this.writeKeySpec;
    }

    @Override
    public Cipher getWriteCipher() {
        if (this.writeCipher == null) {
            try {
                String AES_GCM_NOPADDING = "AES/GCM/NoPadding";
                this.writeCipher = Cipher.getInstance(AES_GCM_NOPADDING);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new QuicRuntimeException(e);
            }
        }
        return this.writeCipher;
    }

    @Override
    public byte[] aeadEncrypt(byte[] associatedData, byte[] message, byte[] nonce) {
        Cipher aeadCipher = this.getWriteCipher();
        SecretKeySpec secretKey = this.getWriteKeySpec();
        try {
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, nonce);
            aeadCipher.init(1, (Key)secretKey, parameterSpec);
            aeadCipher.updateAAD(associatedData);
            return aeadCipher.doFinal(message);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public byte[] aeadDecrypt(byte[] associatedData, byte[] message, byte[] nonce) throws DecryptionException {
        if (message.length <= 16) {
            throw new DecryptionException("ciphertext must be longer than 16 bytes");
        }
        SecretKeySpec secretKey = this.getWriteKeySpec();
        Cipher aeadCipher = this.getWriteCipher();
        try {
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, nonce);
            aeadCipher.init(2, (Key)secretKey, parameterSpec);
            aeadCipher.updateAAD(associatedData);
            return aeadCipher.doFinal(message);
        }
        catch (AEADBadTagException decryptError) {
            throw new DecryptionException();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException();
        }
    }
}

