/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.crypto;

import at.favre.lib.crypto.HKDF;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.ChaCha20ParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.QuicRuntimeException;
import net.luminis.quic.Role;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.BaseAeadImpl;
import net.luminis.quic.log.Logger;

public class ChaCha20
extends BaseAeadImpl {
    public ChaCha20(Version quicVersion, Role server, Logger log) {
        super(quicVersion, server, log);
    }

    @Override
    protected short getHashLength() {
        return 32;
    }

    @Override
    protected short getKeyLength() {
        return 32;
    }

    @Override
    protected HKDF getHKDF() {
        return HKDF.fromHmacSha256();
    }

    @Override
    public Cipher getHeaderProtectionCipher() {
        if (this.hpCipher == null) {
            try {
                this.hpCipher = Cipher.getInstance("ChaCha20");
            }
            catch (NoSuchAlgorithmException e) {
                throw new QuicRuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException();
            }
        }
        return this.hpCipher;
    }

    @Override
    public SecretKeySpec getWriteKeySpec() {
        if (this.writeKeySpec == null) {
            this.writeKeySpec = new SecretKeySpec(this.writeKey, "ChaCha20-Poly1305");
        }
        return this.writeKeySpec;
    }

    @Override
    public Cipher getWriteCipher() {
        if (this.writeCipher == null) {
            try {
                this.writeCipher = Cipher.getInstance("ChaCha20-Poly1305");
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new QuicRuntimeException(e);
            }
        }
        return this.writeCipher;
    }

    @Override
    public byte[] aeadEncrypt(byte[] associatedData, byte[] message, byte[] nonce) {
        try {
            Cipher aeadCipher = this.getWriteCipher();
            IvParameterSpec chacha20poly1305Spec = new IvParameterSpec(nonce);
            SecretKeySpec key = this.getWriteKeySpec();
            aeadCipher.init(1, (Key)key, chacha20poly1305Spec);
            aeadCipher.updateAAD(associatedData);
            return aeadCipher.doFinal(message);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public byte[] aeadDecrypt(byte[] associatedData, byte[] message, byte[] nonce) throws DecryptionException {
        try {
            Cipher aeadCipher = this.getWriteCipher();
            IvParameterSpec chacha20poly1305Spec = new IvParameterSpec(nonce);
            SecretKeySpec key = this.getWriteKeySpec();
            aeadCipher.init(2, (Key)key, chacha20poly1305Spec);
            aeadCipher.updateAAD(associatedData);
            return aeadCipher.doFinal(message);
        }
        catch (AEADBadTagException decryptError) {
            throw new DecryptionException();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public byte[] createHeaderProtectionMask(byte[] sample) {
        try {
            Cipher hpCipher = Cipher.getInstance("ChaCha20");
            byte[] nonce = Arrays.copyOfRange(sample, 4, 16);
            byte[] counterBytes = new byte[]{sample[3], sample[2], sample[1], sample[0]};
            int counter = ByteBuffer.wrap(counterBytes).getInt();
            ChaCha20ParameterSpec chaCha20ParameterSpec = new ChaCha20ParameterSpec(nonce, counter);
            SecretKeySpec key = new SecretKeySpec(this.hp, "ChaCha20");
            hpCipher.init(1, (Key)key, chaCha20ParameterSpec);
            byte[] mask = hpCipher.doFinal(new byte[]{0, 0, 0, 0, 0});
            return mask;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new QuicRuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException();
        }
        catch (BadPaddingException e) {
            throw new RuntimeException();
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException();
        }
    }
}

