/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class ConnectionCloseFrame
extends QuicFrame {
    private long errorCode;
    private int triggeringFrameType;
    private byte[] reasonPhrase = new byte[0];
    private int tlsError = -1;
    private int frameType;

    public ConnectionCloseFrame(Version quicVersion) {
        this.frameType = 28;
        this.errorCode = 0L;
    }

    public ConnectionCloseFrame(Version quicVersion, long error, String reason) {
        this.frameType = 28;
        this.errorCode = error;
        if (this.errorCode >= 256L && this.errorCode < 512L) {
            this.tlsError = (int)(this.errorCode - 256L);
        }
        if (reason != null && !reason.isBlank()) {
            this.reasonPhrase = reason.getBytes(StandardCharsets.UTF_8);
        }
    }

    public ConnectionCloseFrame(Version quicVersion, long error, boolean quicError, String reason) {
        this.frameType = quicError ? 28 : 29;
        this.errorCode = error;
        if (this.errorCode >= 256L && this.errorCode < 512L) {
            this.tlsError = (int)(this.errorCode - 256L);
        }
        if (reason != null && !reason.isBlank()) {
            this.reasonPhrase = reason.getBytes(StandardCharsets.UTF_8);
        }
    }

    public ConnectionCloseFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        int reasonPhraseLength;
        this.frameType = buffer.get() & 0xFF;
        if (this.frameType != 28 && this.frameType != 29) {
            throw new RuntimeException();
        }
        this.errorCode = VariableLengthInteger.parseLong(buffer);
        if (this.frameType == 28) {
            this.triggeringFrameType = VariableLengthInteger.parse(buffer);
        }
        if ((reasonPhraseLength = VariableLengthInteger.parse(buffer)) > 0) {
            this.reasonPhrase = new byte[reasonPhraseLength];
            buffer.get(this.reasonPhrase);
        }
        if (this.frameType == 28 && this.errorCode >= 256L && this.errorCode < 512L) {
            this.tlsError = (int)(this.errorCode - 256L);
        }
        return this;
    }

    public boolean hasTransportError() {
        return this.frameType == 28 && this.errorCode != 0L;
    }

    public boolean hasTlsError() {
        return this.tlsError != -1;
    }

    public long getTlsError() {
        if (this.hasTlsError()) {
            return this.tlsError;
        }
        throw new IllegalStateException("Close does not have a TLS error");
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public boolean hasReasonPhrase() {
        return this.reasonPhrase != null;
    }

    public String getReasonPhrase() {
        try {
            return new String(this.reasonPhrase, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public boolean hasApplicationProtocolError() {
        return this.frameType == 29 && this.errorCode != 0L;
    }

    public boolean hasError() {
        return this.hasTransportError() || this.hasApplicationProtocolError();
    }

    public int getFrameType() {
        return this.frameType;
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.errorCode) + VariableLengthInteger.bytesNeeded(0L) + VariableLengthInteger.bytesNeeded(this.reasonPhrase.length) + this.reasonPhrase.length;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)28);
        VariableLengthInteger.encode(this.errorCode, buffer);
        VariableLengthInteger.encode(0, buffer);
        VariableLengthInteger.encode(this.reasonPhrase.length, buffer);
        buffer.put(this.reasonPhrase);
    }

    @Override
    public boolean isAckEliciting() {
        return false;
    }

    public String toString() {
        return "ConnectionCloseFrame[" + (Serializable)(this.hasTlsError() ? "TLS " + this.tlsError : Long.valueOf(this.errorCode)) + "|" + this.triggeringFrameType + "|" + (this.reasonPhrase != null ? new String(this.reasonPhrase) : "-") + "]";
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

