/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class MaxDataFrame
extends QuicFrame {
    private long maxData;

    public MaxDataFrame() {
    }

    public MaxDataFrame(long flowControlMax) {
        this.maxData = flowControlMax;
    }

    public MaxDataFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        buffer.get();
        this.maxData = VariableLengthInteger.parseLong(buffer);
        return this;
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.maxData);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)16);
        VariableLengthInteger.encode(this.maxData, buffer);
    }

    public long getMaxData() {
        return this.maxData;
    }

    public String toString() {
        return "MaxDataFrame[" + this.maxData + "]";
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

