/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.tls.util.ByteUtils;

public class PathChallengeFrame
extends QuicFrame {
    private byte[] data;

    public PathChallengeFrame(Version quicVersion, byte[] data) {
        if (data.length != 8) {
            throw new IllegalArgumentException();
        }
        this.data = data;
    }

    public PathChallengeFrame(Version quicVersion) {
    }

    public PathChallengeFrame parse(ByteBuffer buffer, Logger log) {
        byte frameType = buffer.get();
        if (frameType != 26) {
            throw new RuntimeException();
        }
        this.data = new byte[8];
        buffer.get(this.data);
        return this;
    }

    @Override
    public int getFrameLength() {
        return 9;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)26);
        buffer.put(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "PathChallengeFrame[" + ByteUtils.bytesToHex((byte[])this.data) + "]";
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

