/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.packet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.InvalidPacketException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.Aead;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public abstract class LongHeaderPacket
extends QuicPacket {
    private static final int MAX_PACKET_SIZE = 1500;
    private static int MIN_PACKET_LENGTH = 10;
    protected byte[] sourceConnectionId;

    public static boolean isLongHeaderPacket(byte flags, Version quicVersion) {
        return (flags & 0xC0) == 192;
    }

    public LongHeaderPacket(Version quicVersion) {
        this.quicVersion = quicVersion;
    }

    public LongHeaderPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destConnectionId, QuicFrame frame) {
        this.quicVersion = quicVersion;
        this.sourceConnectionId = sourceConnectionId;
        this.destinationConnectionId = destConnectionId;
        this.frames = new ArrayList();
        if (frame != null) {
            this.frames.add(frame);
        }
    }

    public LongHeaderPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destConnectionId, List<QuicFrame> frames) {
        if (frames == null) {
            throw new IllegalArgumentException();
        }
        this.quicVersion = quicVersion;
        this.sourceConnectionId = sourceConnectionId;
        this.destinationConnectionId = destConnectionId;
        this.frames = frames;
    }

    @Override
    public byte[] generatePacketBytes(Aead aead) {
        assert (this.packetNumber >= 0L);
        ByteBuffer packetBuffer = ByteBuffer.allocate(1500);
        this.generateFrameHeaderInvariant(packetBuffer);
        this.generateAdditionalFields(packetBuffer);
        byte[] encodedPacketNumber = LongHeaderPacket.encodePacketNumber(this.packetNumber);
        ByteBuffer frameBytes = this.generatePayloadBytes(encodedPacketNumber.length);
        this.addLength(packetBuffer, encodedPacketNumber.length, frameBytes.limit());
        packetBuffer.put(encodedPacketNumber);
        this.protectPacketNumberAndPayload(packetBuffer, encodedPacketNumber.length, frameBytes, 0, aead);
        packetBuffer.limit(packetBuffer.position());
        this.packetSize = packetBuffer.limit();
        byte[] packetBytes = new byte[packetBuffer.position()];
        packetBuffer.rewind();
        packetBuffer.get(packetBytes);
        this.packetSize = packetBytes.length;
        return packetBytes;
    }

    @Override
    public int estimateLength(int additionalPayload) {
        int packetNumberSize = LongHeaderPacket.computePacketNumberSize(this.packetNumber);
        int payloadSize = this.getFrames().stream().mapToInt(f -> f.getFrameLength()).sum() + additionalPayload;
        int padding = Integer.max(0, 4 - packetNumberSize - payloadSize);
        return 6 + this.destinationConnectionId.length + 1 + this.sourceConnectionId.length + this.estimateAdditionalFieldsLength() + (payloadSize + 1 > 63 ? 2 : 1) + LongHeaderPacket.computePacketNumberSize(this.packetNumber) + payloadSize + padding + 16;
    }

    protected void generateFrameHeaderInvariant(ByteBuffer packetBuffer) {
        byte flags = LongHeaderPacket.encodePacketNumberLength((byte)(0xC0 | this.getPacketType() << 4), this.packetNumber);
        LongHeaderPacket.encodePacketNumberLength(flags, this.packetNumber);
        packetBuffer.put(flags);
        packetBuffer.put(this.quicVersion.getBytes());
        packetBuffer.put((byte)this.destinationConnectionId.length);
        packetBuffer.put(this.destinationConnectionId);
        packetBuffer.put((byte)this.sourceConnectionId.length);
        packetBuffer.put(this.sourceConnectionId);
    }

    protected abstract byte getPacketType();

    protected abstract void generateAdditionalFields(ByteBuffer var1);

    protected abstract int estimateAdditionalFieldsLength();

    private void addLength(ByteBuffer packetBuffer, int packetNumberLength, int payloadSize) {
        int packetLength = payloadSize + 16 + packetNumberLength;
        VariableLengthInteger.encode(packetLength, packetBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(ByteBuffer buffer, Aead aead, long largestPacketNumber, Logger log, int sourceConnectionIdLength) throws DecryptionException, InvalidPacketException {
        int length;
        log.debug("Parsing " + this.getClass().getSimpleName());
        if (buffer.position() != 0) {
            throw new IllegalStateException();
        }
        if (buffer.remaining() < MIN_PACKET_LENGTH) {
            throw new InvalidPacketException();
        }
        byte flags = buffer.get();
        this.checkPacketType((flags & 0x30) >> 4);
        boolean matchingVersion = Version.parse(buffer.getInt()).equals(this.quicVersion);
        if (!matchingVersion) {
            throw new InvalidPacketException("Version does not match version of the connection");
        }
        byte dstConnIdLength = buffer.get();
        if (dstConnIdLength < 0 || dstConnIdLength > 20) {
            throw new InvalidPacketException();
        }
        if (buffer.remaining() < dstConnIdLength) {
            throw new InvalidPacketException();
        }
        this.destinationConnectionId = new byte[dstConnIdLength];
        buffer.get(this.destinationConnectionId);
        byte srcConnIdLength = buffer.get();
        if (srcConnIdLength < 0 || srcConnIdLength > 20) {
            throw new InvalidPacketException();
        }
        if (buffer.remaining() < srcConnIdLength) {
            throw new InvalidPacketException();
        }
        this.sourceConnectionId = new byte[srcConnIdLength];
        buffer.get(this.sourceConnectionId);
        log.debug("Destination connection id", this.destinationConnectionId);
        log.debug("Source connection id", this.sourceConnectionId);
        this.parseAdditionalFields(buffer);
        try {
            length = VariableLengthInteger.parse(buffer);
        }
        catch (IllegalArgumentException | InvalidIntegerEncodingException invalidInt) {
            throw new InvalidPacketException();
        }
        log.debug("Length (PN + payload): " + length);
        try {
            this.parsePacketNumberAndPayload(buffer, flags, length, aead, largestPacketNumber, log);
        }
        finally {
            this.packetSize = buffer.position() - 0;
        }
    }

    public String toString() {
        return "Packet " + (this.isProbe ? "P" : "") + this.getEncryptionLevel().name().charAt(0) + "|" + (Serializable)(this.packetNumber >= 0L ? Long.valueOf(this.packetNumber) : ".") + "|L|" + (Serializable)(this.packetSize >= 0 ? Integer.valueOf(this.packetSize) : ".") + "|" + this.frames.size() + "  " + this.frames.stream().map(f -> f.toString()).collect(Collectors.joining(" "));
    }

    public byte[] getSourceConnectionId() {
        return this.sourceConnectionId;
    }

    protected void checkPacketType(int type) {
        if (type != this.getPacketType()) {
            throw new RuntimeException();
        }
    }

    protected abstract void parseAdditionalFields(ByteBuffer var1) throws InvalidPacketException;
}

