/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.packet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.PnSpace;
import net.luminis.quic.Version;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.packet.LongHeaderPacket;

public class ZeroRttPacket
extends LongHeaderPacket {
    private static int V1_type = 1;
    private static int V2_type = 2;

    public static boolean isZeroRTT(int type, Version quicVersion) {
        if (quicVersion.isV2()) {
            return type == V2_type;
        }
        return type == V1_type;
    }

    public ZeroRttPacket(Version quicVersion) {
        super(quicVersion);
    }

    public ZeroRttPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destConnectionId, QuicFrame frame) {
        super(quicVersion, sourceConnectionId, destConnectionId, frame);
    }

    public ZeroRttPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destConnectionId, List<QuicFrame> frames) {
        super(quicVersion, sourceConnectionId, destConnectionId, frames);
    }

    @Override
    protected byte getPacketType() {
        if (this.quicVersion.isV2()) {
            return (byte)V2_type;
        }
        return (byte)V1_type;
    }

    @Override
    protected void generateAdditionalFields(ByteBuffer packetBuffer) {
    }

    @Override
    protected int estimateAdditionalFieldsLength() {
        return 0;
    }

    @Override
    protected void parseAdditionalFields(ByteBuffer buffer) {
    }

    @Override
    public EncryptionLevel getEncryptionLevel() {
        return EncryptionLevel.ZeroRTT;
    }

    @Override
    public PnSpace getPnSpace() {
        return PnSpace.App;
    }

    @Override
    public PacketProcessor.ProcessResult accept(PacketProcessor processor, Instant time) {
        return processor.process(this, time);
    }

    @Override
    public String toString() {
        return "Packet " + this.getEncryptionLevel().name().charAt(0) + "|" + (Serializable)(this.packetNumber >= 0L ? Long.valueOf(this.packetNumber) : ".") + "|Z|" + (Serializable)(this.packetSize >= 0 ? Integer.valueOf(this.packetSize) : ".") + "|" + this.frames.size() + "  " + this.frames.stream().map(f -> f.toString()).collect(Collectors.joining(" "));
    }
}

