/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.sample.echo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.QuicStream;
import net.luminis.quic.Version;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.SysOutLogger;
import net.luminis.quic.server.ApplicationProtocolConnection;
import net.luminis.quic.server.ServerConnector;

public class EchoServer {
    private static void usageAndExit() {
        System.err.println("Usage: cert file, cert key file, port number");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3 || !Arrays.stream(args).limit(2L).allMatch(a -> new File((String)a).exists())) {
            EchoServer.usageAndExit();
        }
        int port = -1;
        try {
            port = Integer.valueOf(args[2]);
        }
        catch (NumberFormatException noNumber) {
            EchoServer.usageAndExit();
        }
        SysOutLogger log = new SysOutLogger();
        log.timeFormat(Logger.TimeFormat.Long);
        log.logWarning(true);
        log.logInfo(true);
        ServerConnector serverConnector = new ServerConnector(port, (InputStream)new FileInputStream(args[0]), (InputStream)new FileInputStream(args[1]), List.of(Version.QUIC_version_1), false, (Logger)log);
        EchoServer.registerProtocolHandler(serverConnector, log);
        serverConnector.start();
        log.info("Started echo server on port " + port);
    }

    private static void registerProtocolHandler(ServerConnector serverConnector, Logger log) {
        serverConnector.registerApplicationProtocol("echo", (protocol, quicConnection) -> new EchoProtocolConnection(quicConnection, log));
    }

    static class EchoProtocolConnection
    implements ApplicationProtocolConnection {
        private Logger log;

        public EchoProtocolConnection(QuicConnection quicConnection, Logger log) {
            this.log = log;
        }

        @Override
        public void acceptPeerInitiatedStream(QuicStream quicStream) {
            new Thread(() -> this.handleEchoRequest(quicStream)).start();
        }

        private void handleEchoRequest(QuicStream quicStream) {
            try {
                byte[] bytesRead = quicStream.getInputStream().readAllBytes();
                System.out.println("Read echo request with " + bytesRead.length + " bytes of data.");
                quicStream.getOutputStream().write(bytesRead);
                quicStream.getOutputStream().close();
            }
            catch (IOException e) {
                this.log.error("Reading quic stream failed", e);
            }
        }
    }
}

