/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.send;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Function;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.frame.PingFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.send.SendRequest;

public class SendRequestQueue {
    private final Clock clock;
    private final EncryptionLevel encryptionLevel;
    private Deque<SendRequest> requestQueue = new ConcurrentLinkedDeque<SendRequest>();
    private Deque<List<QuicFrame>> probeQueue = new ConcurrentLinkedDeque<List<QuicFrame>>();
    private final Object ackLock = new Object();
    private Instant nextAckTime;
    private volatile boolean cleared;

    public SendRequestQueue(EncryptionLevel level) {
        this(Clock.systemUTC(), level);
    }

    public SendRequestQueue(Clock clock, EncryptionLevel level) {
        this.clock = clock;
        this.encryptionLevel = level;
    }

    public void addRequest(QuicFrame fixedFrame, Consumer<QuicFrame> lostCallback) {
        this.requestQueue.addLast(new SendRequest(fixedFrame.getFrameLength(), actualMaxSize -> fixedFrame, lostCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAckRequest() {
        Object object = this.ackLock;
        synchronized (object) {
            this.nextAckTime = this.clock.instant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAckRequest(int delay) {
        Instant requestedAckTime = this.clock.instant().plusMillis(delay);
        Object object = this.ackLock;
        synchronized (object) {
            if (this.nextAckTime == null || requestedAckTime.isBefore(this.nextAckTime)) {
                this.nextAckTime = requestedAckTime;
            }
        }
    }

    public void addProbeRequest() {
        this.probeQueue.addLast(Collections.emptyList());
    }

    public void addProbeRequest(List<QuicFrame> frames) {
        this.probeQueue.addLast(frames);
    }

    public boolean hasProbe() {
        return !this.probeQueue.isEmpty();
    }

    public boolean hasProbeWithData() {
        List<QuicFrame> firstProbe = this.probeQueue.peekFirst();
        return firstProbe != null && !firstProbe.isEmpty();
    }

    public List<QuicFrame> getProbe() {
        List<QuicFrame> probe = this.probeQueue.pollFirst();
        if (probe != null) {
            return probe;
        }
        return List.of(new PingFrame());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mustSendAck() {
        Instant now = this.clock.instant();
        Object object = this.ackLock;
        synchronized (object) {
            return this.nextAckTime != null && (now.isAfter(this.nextAckTime) || Duration.between(now, this.nextAckTime).toMillis() < 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mustAndWillSendAck() {
        Instant now = this.clock.instant();
        Object object = this.ackLock;
        synchronized (object) {
            boolean must;
            boolean bl = must = this.nextAckTime != null && (now.isAfter(this.nextAckTime) || Duration.between(now, this.nextAckTime).toMillis() < 1L);
            if (must) {
                this.nextAckTime = null;
            }
            return must;
        }
    }

    public Instant getAck() {
        Object object = this.ackLock;
        synchronized (object) {
            Instant instant;
            try {
                instant = this.nextAckTime;
                this.nextAckTime = null;
            }
            catch (Throwable throwable) {
                this.nextAckTime = null;
                throw throwable;
            }
            return instant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instant nextDelayedSend() {
        Object object = this.ackLock;
        synchronized (object) {
            return this.nextAckTime;
        }
    }

    public void addRequest(Function<Integer, QuicFrame> frameSupplier, int estimatedSize, Consumer<QuicFrame> lostCallback) {
        this.requestQueue.addLast(new SendRequest(estimatedSize, frameSupplier, lostCallback));
    }

    public boolean hasRequests() {
        return !this.requestQueue.isEmpty();
    }

    public Optional<SendRequest> next(int maxFrameLength) {
        if (maxFrameLength < 1) {
            return Optional.empty();
        }
        try {
            Iterator<SendRequest> iterator = this.requestQueue.iterator();
            while (iterator.hasNext()) {
                SendRequest next = iterator.next();
                if (next.getEstimatedSize() > maxFrameLength) continue;
                iterator.remove();
                return Optional.of(next);
            }
            return Optional.empty();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            if (this.cleared) {
                return Optional.empty();
            }
            throw concurrentModificationException;
        }
    }

    public void clear() {
        this.clear(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(boolean dropAcks) {
        this.cleared = true;
        this.requestQueue.clear();
        this.probeQueue.clear();
        if (dropAcks) {
            Object object = this.ackLock;
            synchronized (object) {
                this.nextAckTime = null;
            }
        }
    }

    public boolean isEmpty() {
        return this.isEmpty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(boolean ignoreAcks) {
        if (ignoreAcks) {
            return this.requestQueue.isEmpty();
        }
        Object object = this.ackLock;
        synchronized (object) {
            return this.requestQueue.isEmpty() && this.nextAckTime == null;
        }
    }

    public String toString() {
        return "SendRequestQueue[" + this.encryptionLevel + "]";
    }
}

