/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.server;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.function.Consumer;
import net.luminis.quic.Version;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.InitialPacket;
import net.luminis.quic.server.ApplicationProtocolRegistry;
import net.luminis.quic.server.ServerConnectionImpl;
import net.luminis.quic.server.ServerConnectionProxy;
import net.luminis.quic.server.ServerConnectionRegistry;
import net.luminis.quic.server.ServerConnectionThread;
import net.luminis.tls.handshake.TlsServerEngineFactory;

public class ServerConnectionFactory {
    private final int connectionIdLength;
    private final Logger log;
    private final TlsServerEngineFactory tlsServerEngineFactory;
    private final ApplicationProtocolRegistry applicationProtocolRegistry;
    private final DatagramSocket serverSocket;
    private final int initalRtt;
    private final Consumer<ServerConnectionImpl> closeCallback;
    private final boolean requireRetry;
    private final ServerConnectionRegistry connectionRegistry;

    public ServerConnectionFactory(int connectionIdLength, DatagramSocket serverSocket, TlsServerEngineFactory tlsServerEngineFactory, boolean requireRetry, ApplicationProtocolRegistry applicationProtocolRegistry, int initalRtt, ServerConnectionRegistry connectionRegistry, Consumer<ServerConnectionImpl> closeCallback, Logger log) {
        if (connectionIdLength > 20 || connectionIdLength < 0) {
            throw new IllegalArgumentException();
        }
        this.tlsServerEngineFactory = tlsServerEngineFactory;
        this.requireRetry = requireRetry;
        this.applicationProtocolRegistry = applicationProtocolRegistry;
        this.connectionIdLength = connectionIdLength;
        this.connectionRegistry = connectionRegistry;
        this.closeCallback = closeCallback;
        this.log = log;
        this.serverSocket = serverSocket;
        this.initalRtt = initalRtt;
    }

    public ServerConnectionImpl createNewConnection(Version version, InetSocketAddress clientAddress, byte[] scid, byte[] originalDcid) {
        return new ServerConnectionImpl(version, this.serverSocket, clientAddress, scid, originalDcid, this.connectionIdLength, this.tlsServerEngineFactory, this.requireRetry, this.applicationProtocolRegistry, this.initalRtt, this.connectionRegistry, this.closeCallback, this.log);
    }

    public ServerConnectionProxy createServerConnectionProxy(ServerConnectionImpl connection, InitialPacket initialPacket, Instant packetReceived, ByteBuffer datagram) {
        return new ServerConnectionThread(connection, initialPacket, packetReceived, datagram);
    }
}

