/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.stream;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.luminis.quic.ImplementationError;
import net.luminis.quic.QuicConstants;
import net.luminis.quic.QuicStream;
import net.luminis.quic.Role;
import net.luminis.quic.TransportError;
import net.luminis.quic.TransportParameters;
import net.luminis.quic.frame.MaxDataFrame;
import net.luminis.quic.frame.MaxStreamDataFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.NullLogger;
import net.luminis.quic.stream.BlockReason;
import net.luminis.quic.stream.FlowControlUpdateListener;

public class FlowControl {
    private final Role role;
    private final long initialMaxData;
    private final long initialMaxStreamDataBidiLocal;
    private final long initialMaxStreamDataBidiRemote;
    private final long initialMaxStreamDataUni;
    private long maxDataAllowed;
    private long maxDataAssigned;
    private Map<Integer, Long> maxStreamDataAllowed;
    private Map<Integer, Long> maxStreamDataAssigned;
    private final Logger log;
    private final Map<Integer, FlowControlUpdateListener> streamListeners;
    private int maxOpenedStreamId;

    public FlowControl(Role role, long initialMaxData, long initialMaxStreamDataBidiLocal, long initialMaxStreamDataBidiRemote, long initialMaxStreamDataUni) {
        this(role, initialMaxData, initialMaxStreamDataBidiLocal, initialMaxStreamDataBidiRemote, initialMaxStreamDataUni, new NullLogger());
    }

    public FlowControl(Role role, long initialMaxData, long initialMaxStreamDataBidiLocal, long initialMaxStreamDataBidiRemote, long initialMaxStreamDataUni, Logger log) {
        this.role = role;
        this.initialMaxData = initialMaxData;
        this.initialMaxStreamDataBidiLocal = initialMaxStreamDataBidiLocal;
        this.initialMaxStreamDataBidiRemote = initialMaxStreamDataBidiRemote;
        this.initialMaxStreamDataUni = initialMaxStreamDataUni;
        this.log = log;
        this.streamListeners = new ConcurrentHashMap<Integer, FlowControlUpdateListener>();
        this.maxDataAllowed = initialMaxData;
        this.maxDataAssigned = 0L;
        this.maxStreamDataAllowed = new HashMap<Integer, Long>();
        this.maxStreamDataAssigned = new HashMap<Integer, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long increaseFlowControlLimit(QuicStream stream, long requestedLimit) {
        int streamId = stream.getStreamId();
        FlowControl flowControl = this;
        synchronized (flowControl) {
            long possibleStreamIncrement = this.currentStreamCredits(stream);
            long requestedIncrement = requestedLimit - this.maxStreamDataAssigned.get(streamId);
            long proposedStreamIncrement = Long.min(requestedIncrement, possibleStreamIncrement);
            if (requestedIncrement < 0L) {
                throw new IllegalArgumentException();
            }
            this.maxDataAssigned += proposedStreamIncrement;
            long newStreamLimit = this.maxStreamDataAssigned.get(streamId) + proposedStreamIncrement;
            this.maxStreamDataAssigned.put(streamId, newStreamLimit);
            return newStreamLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFlowControlLimit(QuicStream stream) {
        FlowControl flowControl = this;
        synchronized (flowControl) {
            return this.maxStreamDataAssigned.get(stream.getStreamId()) + this.currentStreamCredits(stream);
        }
    }

    public BlockReason getFlowControlBlockReason(QuicStream stream) {
        int streamId = stream.getStreamId();
        if (this.maxStreamDataAssigned.get(streamId).equals(this.maxStreamDataAllowed.get(streamId))) {
            return BlockReason.STREAM_DATA_BLOCKED;
        }
        if (this.maxDataAllowed == this.maxDataAssigned) {
            return BlockReason.DATA_BLOCKED;
        }
        return BlockReason.NOT_BLOCKED;
    }

    public long getConnectionDataLimit() {
        return this.maxDataAllowed;
    }

    public synchronized void updateInitialValues(TransportParameters peerTransportParameters) {
        if (this.role == Role.Server) {
            throw new ImplementationError();
        }
        if (peerTransportParameters.getInitialMaxData() > this.initialMaxData) {
            this.log.info("Increasing initial max data from " + this.initialMaxData + " to " + peerTransportParameters.getInitialMaxData());
            if (peerTransportParameters.getInitialMaxData() > this.maxDataAllowed) {
                this.maxDataAllowed = peerTransportParameters.getInitialMaxData();
            }
        } else if (peerTransportParameters.getInitialMaxData() < this.initialMaxData) {
            this.log.error("Ignoring attempt to reduce initial max data from " + this.initialMaxData + " to " + peerTransportParameters.getInitialMaxData());
        }
        if (peerTransportParameters.getInitialMaxStreamDataBidiLocal() > this.initialMaxStreamDataBidiLocal) {
            this.log.info("Increasing initial max data from " + this.initialMaxStreamDataBidiLocal + " to " + peerTransportParameters.getInitialMaxStreamDataBidiLocal());
            this.maxStreamDataAllowed.entrySet().stream().filter(entry -> (Integer)entry.getKey() % 4 == 1).forEach(entry -> {
                if (peerTransportParameters.getInitialMaxStreamDataBidiLocal() > (Long)entry.getValue()) {
                    this.maxStreamDataAllowed.put((Integer)entry.getKey(), peerTransportParameters.getInitialMaxStreamDataBidiLocal());
                }
            });
        } else if (peerTransportParameters.getInitialMaxStreamDataBidiLocal() < this.initialMaxStreamDataBidiLocal) {
            this.log.error("Ignoring attempt to reduce max data from " + this.initialMaxStreamDataBidiLocal + " to " + peerTransportParameters.getInitialMaxStreamDataBidiLocal());
        }
        if (peerTransportParameters.getInitialMaxStreamDataBidiRemote() > this.initialMaxStreamDataBidiRemote) {
            this.log.info("Increasing initial max data from " + this.initialMaxStreamDataBidiRemote + " to " + peerTransportParameters.getInitialMaxStreamDataBidiRemote());
            this.maxStreamDataAllowed.entrySet().stream().filter(entry -> (Integer)entry.getKey() % 4 == 0).forEach(entry -> {
                if (peerTransportParameters.getInitialMaxStreamDataBidiRemote() > (Long)entry.getValue()) {
                    this.maxStreamDataAllowed.put((Integer)entry.getKey(), peerTransportParameters.getInitialMaxStreamDataBidiRemote());
                }
            });
        } else if (peerTransportParameters.getInitialMaxStreamDataBidiRemote() < this.initialMaxStreamDataBidiRemote) {
            this.log.error("Ignoring attempt to reduce max data from " + this.initialMaxStreamDataBidiRemote + " to " + peerTransportParameters.getInitialMaxStreamDataBidiRemote());
        }
        if (peerTransportParameters.getInitialMaxStreamDataUni() > this.initialMaxStreamDataUni) {
            this.log.info("Increasing initial max data from " + this.initialMaxStreamDataUni + " to " + peerTransportParameters.getInitialMaxStreamDataUni());
            this.maxStreamDataAllowed.entrySet().stream().filter(entry -> (Integer)entry.getKey() % 4 == 2).forEach(entry -> {
                if (peerTransportParameters.getInitialMaxStreamDataUni() > (Long)entry.getValue()) {
                    this.maxStreamDataAllowed.put((Integer)entry.getKey(), peerTransportParameters.getInitialMaxStreamDataUni());
                }
            });
        } else if (peerTransportParameters.getInitialMaxStreamDataUni() < this.initialMaxStreamDataUni) {
            this.log.error("Ignoring attempt to reduce max data from " + this.initialMaxStreamDataUni + " to " + peerTransportParameters.getInitialMaxStreamDataUni());
        }
    }

    public void register(QuicStream stream, FlowControlUpdateListener listener) {
        this.streamListeners.put(stream.getStreamId(), listener);
    }

    public void unregister(QuicStream stream) {
        this.streamListeners.remove(stream.getStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamOpened(QuicStream stream) {
        int streamId = stream.getStreamId();
        FlowControl flowControl = this;
        synchronized (flowControl) {
            if (!this.maxStreamDataAllowed.containsKey(streamId)) {
                this.maxStreamDataAllowed.put(streamId, this.determineInitialMaxStreamData(stream));
                this.maxStreamDataAssigned.put(streamId, 0L);
            }
            if (streamId > this.maxOpenedStreamId) {
                this.maxOpenedStreamId = streamId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamClosed(QuicStream stream) {
        int streamId = stream.getStreamId();
        FlowControl flowControl = this;
        synchronized (flowControl) {
            this.maxStreamDataAssigned.remove(streamId);
            this.maxStreamDataAllowed.remove(streamId);
        }
    }

    private long determineInitialMaxStreamData(QuicStream stream) {
        if (stream.isUnidirectional()) {
            return this.initialMaxStreamDataUni;
        }
        if (this.role == Role.Client && stream.isClientInitiatedBidirectional() || this.role == Role.Server && stream.isServerInitiatedBidirectional()) {
            return this.initialMaxStreamDataBidiRemote;
        }
        if (this.role == Role.Client && stream.isServerInitiatedBidirectional() || this.role == Role.Server && stream.isClientInitiatedBidirectional()) {
            return this.initialMaxStreamDataBidiLocal;
        }
        throw new ImplementationError();
    }

    private long currentStreamCredits(QuicStream stream) {
        long maxPossibleDataIncrement;
        int streamId = stream.getStreamId();
        long allowedByStream = this.maxStreamDataAllowed.get(streamId);
        long maxStreamIncrement = allowedByStream - this.maxStreamDataAssigned.get(streamId);
        if (maxStreamIncrement > (maxPossibleDataIncrement = this.maxDataAllowed - this.maxDataAssigned)) {
            maxStreamIncrement = maxPossibleDataIncrement;
        }
        return maxStreamIncrement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MaxDataFrame frame) {
        FlowControl flowControl = this;
        synchronized (flowControl) {
            if (frame.getMaxData() > this.maxDataAllowed) {
                boolean maxDataWasReached = this.maxDataAllowed == this.maxDataAssigned;
                this.maxDataAllowed = frame.getMaxData();
                if (maxDataWasReached) {
                    this.streamListeners.forEach((streamId, listener) -> {
                        boolean streamWasBlockedByMaxDataOnly;
                        boolean bl = streamWasBlockedByMaxDataOnly = this.maxStreamDataAssigned.get(streamId) != this.maxStreamDataAllowed.get(streamId);
                        if (streamWasBlockedByMaxDataOnly) {
                            listener.streamNotBlocked((int)streamId);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MaxStreamDataFrame frame) throws TransportError {
        FlowControl flowControl = this;
        synchronized (flowControl) {
            int streamId = frame.getStreamId();
            long maxStreamData = frame.getMaxData();
            if (this.maxStreamDataAllowed.containsKey(streamId)) {
                if (maxStreamData > this.maxStreamDataAllowed.get(streamId)) {
                    boolean streamWasBlocked = this.maxStreamDataAssigned.get(streamId).longValue() == this.maxStreamDataAllowed.get(streamId).longValue() && this.maxDataAssigned != this.maxDataAllowed;
                    this.maxStreamDataAllowed.put(streamId, maxStreamData);
                    if (streamWasBlocked) {
                        this.streamListeners.get(streamId).streamNotBlocked(streamId);
                    }
                }
            } else if (this.locallyInitiated(streamId) && streamId > this.maxOpenedStreamId) {
                throw new TransportError(QuicConstants.TransportErrorCode.STREAM_STATE_ERROR);
            }
        }
    }

    private boolean locallyInitiated(int streamId) {
        if (this.role == Role.Client) {
            return streamId % 2 == 0;
        }
        return streamId % 2 == 1;
    }
}

