/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.util.Optional;
import net.luminis.quic.PnSpace;

public enum EncryptionLevel {
    Initial,
    ZeroRTT,
    Handshake,
    App;


    public boolean higher(EncryptionLevel other) {
        return this.ordinal() > other.ordinal();
    }

    public PnSpace relatedPnSpace() {
        switch (this) {
            case ZeroRTT: {
                return PnSpace.App;
            }
            case Initial: {
                return PnSpace.Initial;
            }
            case Handshake: {
                return PnSpace.Handshake;
            }
            case App: {
                return PnSpace.App;
            }
        }
        return null;
    }

    public Optional<EncryptionLevel> next() {
        switch (this) {
            case ZeroRTT: {
                return Optional.of(Initial);
            }
            case Initial: {
                return Optional.of(Handshake);
            }
            case Handshake: {
                return Optional.of(App);
            }
            case App: {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

