/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.time.Instant;
import java.util.Arrays;
import net.luminis.quic.AckGenerator;
import net.luminis.quic.FrameReceivedListener;
import net.luminis.quic.PnSpace;
import net.luminis.quic.frame.AckFrame;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.send.NullAckGenerator;
import net.luminis.quic.send.Sender;

public class GlobalAckGenerator
implements FrameReceivedListener<AckFrame> {
    private AckGenerator[] ackGenerators = new AckGenerator[PnSpace.values().length];

    public GlobalAckGenerator(Sender sender) {
        Arrays.stream(PnSpace.values()).forEach(pnSpace -> {
            this.ackGenerators[pnSpace.ordinal()] = new AckGenerator((PnSpace)((Object)pnSpace), sender);
        });
    }

    public void packetReceived(QuicPacket packet) {
        if (packet.canBeAcked()) {
            this.ackGenerators[packet.getPnSpace().ordinal()].packetReceived(packet);
        }
    }

    @Override
    public void received(AckFrame frame, PnSpace pnSpace, Instant timeReceived) {
        this.ackGenerators[pnSpace.ordinal()].process(frame);
    }

    public AckGenerator getAckGenerator(PnSpace pnSpace) {
        return this.ackGenerators[pnSpace.ordinal()];
    }

    public void discard(PnSpace pnSpace) {
        this.ackGenerators[pnSpace.ordinal()] = new NullAckGenerator();
    }
}

