/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.VersionHolder;
import net.luminis.quic.frame.PingFrame;
import net.luminis.quic.send.Sender;

public class KeepAliveActor {
    private Clock clock;
    private final VersionHolder quicVersion;
    private final int keepAliveTime;
    private final Sender sender;
    private final Instant started;
    private final ScheduledExecutorService scheduler;
    private final int pingInterval;
    private volatile ScheduledFuture<?> scheduledTask;

    public KeepAliveActor(VersionHolder quicVersion, int keepAliveTime, int peerIdleTimeout, Sender sender) {
        this(Clock.systemUTC(), quicVersion, keepAliveTime, peerIdleTimeout, sender, Executors.newScheduledThreadPool(1));
    }

    KeepAliveActor(Clock clock, VersionHolder quicVersion, int keepAliveTime, int peerIdleTimeout, Sender sender, ScheduledExecutorService scheduler) {
        this.clock = clock;
        this.quicVersion = quicVersion;
        this.keepAliveTime = keepAliveTime;
        this.sender = sender;
        this.scheduler = scheduler;
        this.started = clock.instant();
        this.pingInterval = peerIdleTimeout / 1000 / 2;
        this.scheduleNextPing();
    }

    private void ping() {
        this.sender.send(new PingFrame(this.quicVersion.getVersion()), EncryptionLevel.App);
        this.sender.flush();
        this.scheduleNextPing();
    }

    private void scheduleNextPing() {
        Instant now = this.clock.instant();
        if (Duration.between(this.started, now).compareTo(Duration.of(this.keepAliveTime - this.pingInterval, ChronoUnit.SECONDS)) < 0) {
            this.scheduledTask = this.scheduler.schedule(() -> this.ping(), (long)this.pingInterval, TimeUnit.SECONDS);
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }
}

