/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import net.luminis.quic.DatagramSocketFactory;
import net.luminis.quic.QuicClientConnectionImpl;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.QuicSessionTicket;
import net.luminis.quic.QuicStream;
import net.luminis.quic.TransportParameters;
import net.luminis.quic.Version;
import net.luminis.quic.log.Logger;
import net.luminis.tls.TlsConstants;

public interface QuicClientConnection
extends QuicConnection {
    public void connect(int var1, String var2) throws IOException;

    public void connect(int var1, String var2, TransportParameters var3) throws IOException;

    public List<QuicStream> connect(int var1, String var2, TransportParameters var3, List<StreamEarlyData> var4) throws IOException;

    public void keepAlive(int var1);

    public List<QuicSessionTicket> getNewSessionTickets();

    public InetSocketAddress getLocalAddress();

    public InetSocketAddress getServerAddress();

    public List<X509Certificate> getServerCertificateChain();

    public boolean isConnected();

    public static Builder newBuilder() {
        return QuicClientConnectionImpl.newBuilder();
    }

    public static interface Builder {
        public QuicClientConnectionImpl build() throws SocketException, UnknownHostException;

        public Builder connectTimeout(Duration var1);

        public Builder version(Version var1);

        public Builder initialVersion(Version var1);

        public Builder preferredVersion(Version var1);

        public Builder logger(Logger var1);

        public Builder sessionTicket(QuicSessionTicket var1);

        public Builder proxy(String var1);

        public Builder secrets(Path var1);

        public Builder uri(URI var1);

        public Builder connectionIdLength(int var1);

        public Builder initialRtt(int var1);

        public Builder cipherSuite(TlsConstants.CipherSuite var1);

        public Builder noServerCertificateCheck();

        public Builder quantumReadinessTest(int var1);

        public Builder clientCertificate(X509Certificate var1);

        public Builder clientCertificateKey(PrivateKey var1);

        public Builder datagramSocketFactory(DatagramSocketFactory var1);
    }

    public static class StreamEarlyData {
        byte[] data;
        boolean closeOutput;

        public StreamEarlyData(byte[] data, boolean closeImmediately) {
            this.data = data;
            this.closeOutput = closeImmediately;
        }
    }
}

