/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.X509TrustManager;
import net.luminis.quic.CryptoStream;
import net.luminis.quic.DatagramSocketFactory;
import net.luminis.quic.DefaultDatagramSocketFactory;
import net.luminis.quic.EarlyDataStatus;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.GlobalAckGenerator;
import net.luminis.quic.HandshakeState;
import net.luminis.quic.IdleTimer;
import net.luminis.quic.KeepAliveActor;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.PnSpace;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicConnectionImpl;
import net.luminis.quic.QuicConstants;
import net.luminis.quic.QuicSessionTicket;
import net.luminis.quic.QuicStream;
import net.luminis.quic.RawPacket;
import net.luminis.quic.Receiver;
import net.luminis.quic.Role;
import net.luminis.quic.TransportParameters;
import net.luminis.quic.Version;
import net.luminis.quic.VersionNegotiationFailure;
import net.luminis.quic.cid.ConnectionIdInfo;
import net.luminis.quic.cid.ConnectionIdManager;
import net.luminis.quic.frame.ConnectionCloseFrame;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.HandshakeDoneFrame;
import net.luminis.quic.frame.NewConnectionIdFrame;
import net.luminis.quic.frame.NewTokenFrame;
import net.luminis.quic.frame.PingFrame;
import net.luminis.quic.frame.RetireConnectionIdFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.NullLogger;
import net.luminis.quic.packet.HandshakePacket;
import net.luminis.quic.packet.InitialPacket;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.packet.RetryPacket;
import net.luminis.quic.packet.ShortHeaderPacket;
import net.luminis.quic.packet.VersionNegotiationPacket;
import net.luminis.quic.packet.ZeroRttPacket;
import net.luminis.quic.send.SenderImpl;
import net.luminis.quic.stream.EarlyDataStream;
import net.luminis.quic.stream.FlowControl;
import net.luminis.quic.stream.StreamManager;
import net.luminis.quic.tls.QuicTransportParametersExtension;
import net.luminis.tls.CertificateWithPrivateKey;
import net.luminis.tls.NewSessionTicket;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.TrafficSecrets;
import net.luminis.tls.extension.ApplicationLayerProtocolNegotiationExtension;
import net.luminis.tls.extension.EarlyDataExtension;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.handshake.CertificateMessage;
import net.luminis.tls.handshake.CertificateVerifyMessage;
import net.luminis.tls.handshake.ClientHello;
import net.luminis.tls.handshake.ClientMessageSender;
import net.luminis.tls.handshake.FinishedMessage;
import net.luminis.tls.handshake.HandshakeMessage;
import net.luminis.tls.handshake.TlsClientEngine;
import net.luminis.tls.handshake.TlsStatusEventHandler;
import net.luminis.tls.util.ByteUtils;

public class QuicClientConnectionImpl
extends QuicConnectionImpl
implements QuicClientConnection,
PacketProcessor,
TlsStatusEventHandler,
FrameProcessor {
    private final String host;
    private final int port;
    private final QuicSessionTicket sessionTicket;
    private final TlsClientEngine tlsEngine;
    private final DatagramSocketFactory socketFactory;
    private final DatagramSocket socket;
    private final InetAddress serverAddress;
    private final SenderImpl sender;
    private final Receiver receiver;
    private final StreamManager streamManager;
    private final X509Certificate clientCertificate;
    private final PrivateKey clientCertificateKey;
    private final ConnectionIdManager connectionIdManager;
    private final Version originalVersion;
    private final Version preferredVersion;
    private volatile byte[] token;
    private final CountDownLatch handshakeFinishedCondition = new CountDownLatch(1);
    private volatile TransportParameters peerTransportParams;
    private KeepAliveActor keepAliveActor;
    private String applicationProtocol;
    private final List<QuicSessionTicket> newSessionTickets = Collections.synchronizedList(new ArrayList());
    private boolean ignoreVersionNegotiation;
    private volatile EarlyDataStatus earlyDataStatus = EarlyDataStatus.None;
    private final List<TlsConstants.CipherSuite> cipherSuites;
    private final GlobalAckGenerator ackGenerator;
    private Integer clientHelloEnlargement;
    private volatile Thread receiverThread;
    private volatile String handshakeError;
    private volatile boolean processedRetryPacket = false;

    private QuicClientConnectionImpl(String host, int port, QuicSessionTicket sessionTicket, Version originalVersion, Version preferredVersion, final Logger log, String proxyHost, Path secretsFile, Integer initialRtt, Integer cidLength, List<TlsConstants.CipherSuite> cipherSuites, X509Certificate clientCertificate, PrivateKey clientCertificateKey, DatagramSocketFactory socketFactory) throws UnknownHostException, SocketException {
        super(originalVersion, Role.Client, secretsFile, log);
        log.info("Creating connection with " + host + ":" + port + " with " + originalVersion);
        this.originalVersion = originalVersion;
        this.preferredVersion = preferredVersion;
        this.host = host;
        this.port = port;
        this.serverAddress = InetAddress.getByName(proxyHost != null ? proxyHost : host);
        this.sessionTicket = sessionTicket;
        this.cipherSuites = cipherSuites;
        this.clientCertificate = clientCertificate;
        this.clientCertificateKey = clientCertificateKey;
        this.socketFactory = socketFactory;
        this.socket = socketFactory.createDatagramSocket();
        this.idleTimer = new IdleTimer(this, log);
        this.sender = new SenderImpl(this.quicVersion, QuicClientConnectionImpl.getMaxPacketSize(), this.socket, new InetSocketAddress(this.serverAddress, port), this, initialRtt, log);
        this.sender.enableAllLevels();
        this.idleTimer.setPtoSupplier(this.sender::getPto);
        this.ackGenerator = this.sender.getGlobalAckGenerator();
        this.receiver = new Receiver(this.socket, log, this::abortConnection);
        this.streamManager = new StreamManager(this, Role.Client, log, 10, 10);
        BiConsumer<Integer, String> closeWithErrorFunction = (error, reason) -> this.immediateCloseWithError(EncryptionLevel.App, error.intValue(), (String)reason);
        this.connectionIdManager = new ConnectionIdManager(cidLength, 2, this.sender, closeWithErrorFunction, log);
        this.connectionState = QuicConnectionImpl.Status.Created;
        this.tlsEngine = new TlsClientEngine(new ClientMessageSender(){

            public void send(ClientHello clientHello) {
                CryptoStream cryptoStream = QuicClientConnectionImpl.this.getCryptoStream(EncryptionLevel.Initial);
                cryptoStream.write((HandshakeMessage)clientHello, true);
                QuicClientConnectionImpl.this.connectionState = QuicConnectionImpl.Status.Handshaking;
                QuicClientConnectionImpl.this.connectionSecrets.setClientRandom(clientHello.getClientRandom());
                log.sentPacketInfo(cryptoStream.toStringSent());
            }

            public void send(FinishedMessage finished) {
                CryptoStream cryptoStream = QuicClientConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake);
                cryptoStream.write((HandshakeMessage)finished, true);
                log.sentPacketInfo(cryptoStream.toStringSent());
            }

            public void send(CertificateMessage certificateMessage) throws IOException {
                CryptoStream cryptoStream = QuicClientConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake);
                cryptoStream.write((HandshakeMessage)certificateMessage, true);
                log.sentPacketInfo(cryptoStream.toStringSent());
            }

            public void send(CertificateVerifyMessage certificateVerifyMessage) {
                CryptoStream cryptoStream = QuicClientConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake);
                cryptoStream.write((HandshakeMessage)certificateVerifyMessage, true);
                log.sentPacketInfo(cryptoStream.toStringSent());
            }
        }, (TlsStatusEventHandler)this);
    }

    @Override
    public void connect(int connectionTimeout, String alpn) throws IOException {
        this.connect(connectionTimeout, alpn, null, null);
    }

    @Override
    public void connect(int connectionTimeout, String alpn, TransportParameters transportParameters) throws IOException {
        this.connect(connectionTimeout, alpn, transportParameters, null);
    }

    @Override
    public synchronized List<QuicStream> connect(int connectionTimeout, String applicationProtocol, TransportParameters transportParameters, List<QuicClientConnection.StreamEarlyData> earlyData) throws IOException {
        if (applicationProtocol.trim().isEmpty()) {
            throw new IllegalArgumentException("ALPN cannot be empty");
        }
        if (this.connectionState != QuicConnectionImpl.Status.Created) {
            throw new IllegalStateException("Cannot connect a connection that is in state " + this.connectionState);
        }
        if (earlyData != null && !earlyData.isEmpty() && this.sessionTicket == null) {
            throw new IllegalStateException("Cannot send early data without session ticket");
        }
        this.applicationProtocol = applicationProtocol;
        if (transportParameters != null) {
            this.transportParams = transportParameters;
            this.connectionIdManager.setMaxPeerConnectionIds(this.transportParams.getActiveConnectionIdLimit());
        }
        this.transportParams.setInitialSourceConnectionId(this.connectionIdManager.getInitialConnectionId());
        if (earlyData == null) {
            earlyData = Collections.emptyList();
        }
        this.log.info(String.format("Original destination connection id: %s (scid: %s)", ByteUtils.bytesToHex((byte[])this.connectionIdManager.getOriginalDestinationConnectionId()), ByteUtils.bytesToHex((byte[])this.connectionIdManager.getInitialConnectionId())));
        this.generateInitialKeys();
        this.receiver.start();
        this.sender.start(this.connectionSecrets);
        this.startReceiverLoop();
        this.startHandshake(applicationProtocol, !earlyData.isEmpty());
        List<QuicStream> earlyDataStreams = this.sendEarlyData(earlyData);
        try {
            boolean handshakeFinished = this.handshakeFinishedCondition.await(connectionTimeout, TimeUnit.MILLISECONDS);
            if (!handshakeFinished) {
                this.abortHandshake();
                throw new ConnectException("Connection timed out after " + connectionTimeout + " ms");
            }
            if (this.connectionState != QuicConnectionImpl.Status.Connected) {
                this.abortHandshake();
                throw new ConnectException("Handshake error: " + (this.handshakeError != null ? this.handshakeError : ""));
            }
        }
        catch (InterruptedException e) {
            this.abortHandshake();
            throw new RuntimeException();
        }
        if (!earlyData.isEmpty()) {
            if (this.earlyDataStatus != EarlyDataStatus.Accepted) {
                this.log.info("Server did not accept early data; retransmitting all data.");
            }
            for (QuicStream stream : earlyDataStreams) {
                if (stream == null) continue;
                ((EarlyDataStream)stream).writeRemaining(this.earlyDataStatus == EarlyDataStatus.Accepted);
            }
        }
        return earlyDataStreams;
    }

    private List<QuicStream> sendEarlyData(List<QuicClientConnection.StreamEarlyData> streamEarlyDataList) throws IOException {
        if (!streamEarlyDataList.isEmpty()) {
            TransportParameters rememberedTransportParameters = new TransportParameters();
            this.sessionTicket.copyTo(rememberedTransportParameters);
            this.setZeroRttTransportParameters(rememberedTransportParameters);
            long earlyDataSizeLeft = this.sessionTicket.getInitialMaxData();
            ArrayList<QuicStream> earlyDataStreams = new ArrayList<QuicStream>();
            for (QuicClientConnection.StreamEarlyData streamEarlyData : streamEarlyDataList) {
                EarlyDataStream earlyDataStream = this.streamManager.createEarlyDataStream(true);
                if (earlyDataStream != null) {
                    earlyDataStream.writeEarlyData(streamEarlyData.data, streamEarlyData.closeOutput, earlyDataSizeLeft);
                    earlyDataSizeLeft = Long.max(0L, earlyDataSizeLeft - (long)streamEarlyData.data.length);
                } else {
                    this.log.info("Creating early data stream failed, max bidi streams = " + rememberedTransportParameters.getInitialMaxStreamsBidi());
                }
                earlyDataStreams.add(earlyDataStream);
            }
            this.earlyDataStatus = EarlyDataStatus.Requested;
            return earlyDataStreams;
        }
        return Collections.emptyList();
    }

    private void abortHandshake() {
        this.connectionState = QuicConnectionImpl.Status.Failed;
        this.sender.stop();
        this.terminate();
    }

    @Override
    public void keepAlive(int seconds) {
        if (this.connectionState != QuicConnectionImpl.Status.Connected) {
            throw new IllegalStateException("keep alive can only be set when connected");
        }
        if (this.idleTimer.isEnabled()) {
            this.keepAliveActor = new KeepAliveActor(this.quicVersion, seconds, (int)this.idleTimer.getIdleTimeout(), this.sender);
        }
    }

    public void ping() {
        if (this.connectionState != QuicConnectionImpl.Status.Connected) {
            throw new IllegalStateException("not connected");
        }
        this.sender.send(new PingFrame(this.quicVersion.getVersion()), EncryptionLevel.App);
        this.sender.flush();
    }

    private void startReceiverLoop() {
        this.receiverThread = new Thread(this::receiveAndProcessPackets, "receiver-loop");
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
    }

    private void receiveAndProcessPackets() {
        Thread currentThread = Thread.currentThread();
        int receivedPacketCounter = 0;
        try {
            while (!currentThread.isInterrupted()) {
                RawPacket rawPacket = this.receiver.get(15);
                if (rawPacket == null) continue;
                Duration processDelay = Duration.between(rawPacket.getTimeReceived(), Instant.now());
                this.log.raw("Start processing packet " + ++receivedPacketCounter + " (" + rawPacket.getLength() + " bytes)", rawPacket.getData(), 0, rawPacket.getLength());
                this.log.debug("Processing delay for packet #" + receivedPacketCounter + ": " + processDelay.toMillis() + " ms");
                this.parseAndProcessPackets(receivedPacketCounter, rawPacket.getTimeReceived(), rawPacket.getData(), null);
                this.sender.datagramProcessed(this.receiver.hasMore());
            }
        }
        catch (InterruptedException e) {
            this.log.debug("Terminating receiver loop because of interrupt");
        }
        catch (Exception error) {
            this.log.debug("Terminating receiver loop because of error", error);
            this.abortConnection(error);
        }
    }

    private void generateInitialKeys() {
        this.connectionSecrets.computeInitialKeys(this.connectionIdManager.getCurrentPeerConnectionId());
    }

    private void startHandshake(String applicationProtocol, boolean withEarlyData) {
        this.tlsEngine.setServerName(this.host);
        this.tlsEngine.addSupportedCiphers(this.cipherSuites);
        if (this.clientCertificate != null && this.clientCertificateKey != null) {
            this.tlsEngine.setClientCertificateCallback(authorities -> {
                if (!authorities.contains(this.clientCertificate.getIssuerX500Principal())) {
                    this.log.warn("Client certificate is not signed by one of the requested authorities: " + authorities);
                }
                return new CertificateWithPrivateKey(this.clientCertificate, this.clientCertificateKey);
            });
        }
        if (this.preferredVersion != null && !this.preferredVersion.equals(this.originalVersion)) {
            this.transportParams.setVersionInformation(new TransportParameters.VersionInformation(this.originalVersion, List.of(this.preferredVersion, this.originalVersion)));
        } else if (this.quicVersion.getVersion().isV2()) {
            this.transportParams.setVersionInformation(new TransportParameters.VersionInformation(Version.QUIC_version_2, List.of(Version.QUIC_version_2, Version.QUIC_version_1)));
        }
        QuicTransportParametersExtension tpExtension = new QuicTransportParametersExtension(this.quicVersion.getVersion(), this.transportParams, Role.Client);
        if (this.clientHelloEnlargement != null) {
            tpExtension.addDiscardTransportParameter(this.clientHelloEnlargement);
        }
        this.tlsEngine.add((Extension)tpExtension);
        this.tlsEngine.add((Extension)new ApplicationLayerProtocolNegotiationExtension(applicationProtocol));
        if (withEarlyData) {
            this.tlsEngine.add((Extension)new EarlyDataExtension());
        }
        if (this.sessionTicket != null) {
            this.tlsEngine.setNewSessionTicket((NewSessionTicket)this.sessionTicket);
        }
        try {
            this.tlsEngine.startHandshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void earlySecretsKnown() {
        if (this.sessionTicket != null) {
            TlsConstants.CipherSuite cipher = this.sessionTicket.getCipher();
            this.connectionSecrets.computeEarlySecrets((TrafficSecrets)this.tlsEngine, cipher, this.quicVersion.getVersion());
        }
    }

    public void handshakeSecretsKnown() {
        this.connectionSecrets.computeHandshakeSecrets((TrafficSecrets)this.tlsEngine, this.tlsEngine.getSelectedCipher());
        this.hasHandshakeKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hasHandshakeKeys() {
        Object object = this.handshakeStateLock;
        synchronized (object) {
            if (this.handshakeState.transitionAllowed(HandshakeState.HasHandshakeKeys)) {
                this.handshakeState = HandshakeState.HasHandshakeKeys;
                this.handshakeStateListeners.forEach(l -> l.handshakeStateChangedEvent(this.handshakeState));
            } else {
                this.log.debug("Handshake state cannot be set to HasHandshakeKeys");
            }
        }
        this.postProcessingActions.add(() -> this.discard(PnSpace.Initial, "first Handshake message is being sent"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeFinished() {
        this.connectionSecrets.computeApplicationSecrets((TrafficSecrets)this.tlsEngine);
        Object object = this.handshakeStateLock;
        synchronized (object) {
            if (this.handshakeState.transitionAllowed(HandshakeState.HasAppKeys)) {
                this.handshakeState = HandshakeState.HasAppKeys;
                this.handshakeStateListeners.forEach(l -> l.handshakeStateChangedEvent(this.handshakeState));
            } else {
                this.log.error("Handshake state cannot be set to HasAppKeys; current state is " + this.handshakeState);
            }
        }
        this.connectionState = QuicConnectionImpl.Status.Connected;
        this.handshakeFinishedCondition.countDown();
    }

    public void newSessionTicketReceived(NewSessionTicket ticket) {
        this.addNewSessionTicket(ticket);
    }

    public void extensionsReceived(List<Extension> extensions) {
        extensions.forEach(ex -> {
            if (ex instanceof EarlyDataExtension) {
                this.setEarlyDataStatus(EarlyDataStatus.Accepted);
                this.log.info("Server has accepted early data.");
            } else if (ex instanceof QuicTransportParametersExtension) {
                this.setPeerTransportParameters(((QuicTransportParametersExtension)((Object)ex)).getTransportParameters());
            }
        });
    }

    public boolean isEarlyDataAccepted() {
        return false;
    }

    private void discard(PnSpace pnSpace, String reason) {
        this.sender.discard(pnSpace, reason);
    }

    @Override
    public PacketProcessor.ProcessResult process(InitialPacket packet, Instant time) {
        if (!packet.getVersion().equals(this.quicVersion)) {
            this.handleVersionNegotiation(packet.getVersion());
        }
        this.connectionIdManager.registerInitialPeerCid(packet.getSourceConnectionId());
        this.processFrames(packet, time);
        this.ignoreVersionNegotiation = true;
        return PacketProcessor.ProcessResult.Continue;
    }

    private void handleVersionNegotiation(Version packetVersion) {
        if (!packetVersion.equals(this.quicVersion) && packetVersion.equals(this.preferredVersion) && this.versionNegotiationStatus == QuicConnectionImpl.VersionNegotiationStatus.NotStarted) {
            this.versionNegotiationStatus = QuicConnectionImpl.VersionNegotiationStatus.VersionChangeUnconfirmed;
            this.quicVersion.setVersion(packetVersion);
            this.connectionSecrets.recomputeInitialKeys();
        }
    }

    @Override
    public PacketProcessor.ProcessResult process(HandshakePacket packet, Instant time) {
        this.processFrames(packet, time);
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(ShortHeaderPacket packet, Instant time) {
        this.connectionIdManager.registerConnectionIdInUse(packet.getDestinationConnectionId());
        this.processFrames(packet, time);
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(VersionNegotiationPacket vnPacket, Instant time) {
        if (!this.ignoreVersionNegotiation && !vnPacket.getServerSupportedVersions().contains(this.quicVersion.getVersion())) {
            this.log.info("Server doesn't support " + this.quicVersion + ", but only: " + vnPacket.getServerSupportedVersions().stream().map(v -> v.toString()).collect(Collectors.joining(", ")));
            throw new VersionNegotiationFailure();
        }
        this.log.debug("Ignoring Version Negotiation packet");
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(RetryPacket packet, Instant time) {
        if (packet.validateIntegrityTag(this.connectionIdManager.getOriginalDestinationConnectionId())) {
            if (!this.processedRetryPacket) {
                this.processedRetryPacket = true;
                this.token = packet.getRetryToken();
                this.sender.setInitialToken(this.token);
                this.getCryptoStream(EncryptionLevel.Initial).reset();
                byte[] peerConnectionId = packet.getSourceConnectionId();
                this.connectionIdManager.registerInitialPeerCid(peerConnectionId);
                this.connectionIdManager.registerRetrySourceConnectionId(peerConnectionId);
                this.log.debug("Changing destination connection id into: " + ByteUtils.bytesToHex((byte[])peerConnectionId));
                this.generateInitialKeys();
                this.sender.getCongestionController().reset();
                try {
                    this.tlsEngine.startHandshake();
                }
                catch (IOException iOException) {}
            } else {
                this.log.error("Ignoring RetryPacket, because already processed one.");
            }
        } else {
            this.log.error("Discarding Retry packet, because integrity tag is invalid.");
        }
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(ZeroRttPacket packet, Instant time) {
        return PacketProcessor.ProcessResult.Abort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HandshakeDoneFrame handshakeDoneFrame, QuicPacket packet, Instant timeReceived) {
        Object object = this.handshakeStateLock;
        synchronized (object) {
            if (this.handshakeState.transitionAllowed(HandshakeState.Confirmed)) {
                this.handshakeState = HandshakeState.Confirmed;
                this.handshakeStateListeners.forEach(l -> l.handshakeStateChangedEvent(this.handshakeState));
            } else {
                this.log.debug("Handshake state cannot be set to Confirmed");
            }
        }
        this.sender.discard(PnSpace.Handshake, "HandshakeDone is received");
    }

    @Override
    public void process(NewConnectionIdFrame newConnectionIdFrame, QuicPacket packet, Instant timeReceived) {
        this.connectionIdManager.process(newConnectionIdFrame);
    }

    @Override
    public void process(NewTokenFrame newTokenFrame, QuicPacket packet, Instant timeReceived) {
    }

    @Override
    public void process(RetireConnectionIdFrame retireConnectionIdFrame, QuicPacket packet, Instant timeReceived) {
        this.connectionIdManager.process(retireConnectionIdFrame, packet.getDestinationConnectionId());
    }

    @Override
    protected void immediateCloseWithError(EncryptionLevel level, long error, QuicConnectionImpl.ErrorType errorType, String errorReason) {
        if (this.keepAliveActor != null) {
            this.keepAliveActor.shutdown();
        }
        super.immediateCloseWithError(level, error, errorType, errorReason);
    }

    @Override
    protected void cryptoProcessingErrorOcurred(TlsProtocolException exception) {
        if (this.connectionState == QuicConnectionImpl.Status.Handshaking) {
            this.handshakeError = exception.toString();
        } else {
            this.log.error("Processing crypto frame failed with ", exception);
        }
    }

    @Override
    protected void peerClosedWithError(ConnectionCloseFrame closeFrame) {
        super.peerClosedWithError(closeFrame);
        if (this.connectionState == QuicConnectionImpl.Status.Handshaking) {
            this.handshakeError = "Server closed connection: " + this.determineClosingErrorMessage(closeFrame);
        }
    }

    @Override
    protected void terminate() {
        super.terminate();
        this.handshakeFinishedCondition.countDown();
        this.receiver.shutdown();
        this.socket.close();
        if (this.receiverThread != null) {
            this.receiverThread.interrupt();
        }
    }

    public void changeAddress() {
        try {
            DatagramSocket newSocket = this.socketFactory.createDatagramSocket();
            this.sender.changeAddress(newSocket);
            this.receiver.changeAddress(newSocket);
            this.log.info("Changed local address to " + newSocket.getLocalPort());
        }
        catch (SocketException e) {
            this.log.error("Changing local address failed", e);
        }
    }

    public void updateKeys() {
        if (this.handshakeState == HandshakeState.Confirmed) {
            this.connectionSecrets.getClientAead(EncryptionLevel.App).computeKeyUpdate(true);
        } else {
            this.log.error("Refusing key update because handshake is not yet confirmed");
        }
    }

    @Override
    public int getMaxShortHeaderPacketOverhead() {
        return 1 + this.connectionIdManager.getCurrentPeerConnectionId().length + 4 + 16;
    }

    public TransportParameters getTransportParameters() {
        return this.transportParams;
    }

    public TransportParameters getPeerTransportParameters() {
        return this.peerTransportParams;
    }

    void setPeerTransportParameters(TransportParameters transportParameters) {
        if (!this.verifyConnectionIds(transportParameters)) {
            return;
        }
        if (this.versionNegotiationStatus == QuicConnectionImpl.VersionNegotiationStatus.VersionChangeUnconfirmed) {
            this.verifyVersionNegotiation(transportParameters);
        }
        this.peerTransportParams = transportParameters;
        if (this.flowController == null) {
            this.flowController = new FlowControl(Role.Client, this.peerTransportParams.getInitialMaxData(), this.peerTransportParams.getInitialMaxStreamDataBidiLocal(), this.peerTransportParams.getInitialMaxStreamDataBidiRemote(), this.peerTransportParams.getInitialMaxStreamDataUni(), this.log);
            this.streamManager.setFlowController(this.flowController);
        } else {
            this.log.debug("Updating flow controller with new transport parameters");
            this.flowController.updateInitialValues(this.peerTransportParams);
        }
        this.streamManager.setInitialMaxStreamsBidi(this.peerTransportParams.getInitialMaxStreamsBidi());
        this.streamManager.setInitialMaxStreamsUni(this.peerTransportParams.getInitialMaxStreamsUni());
        this.sender.setReceiverMaxAckDelay(this.peerTransportParams.getMaxAckDelay());
        this.connectionIdManager.registerPeerCidLimit(this.peerTransportParams.getActiveConnectionIdLimit());
        this.determineIdleTimeout(this.transportParams.getMaxIdleTimeout(), this.peerTransportParams.getMaxIdleTimeout());
        this.connectionIdManager.setInitialStatelessResetToken(this.peerTransportParams.getStatelessResetToken());
        if (this.processedRetryPacket) {
            if (this.peerTransportParams.getRetrySourceConnectionId() == null || !this.connectionIdManager.validateRetrySourceConnectionId(this.peerTransportParams.getRetrySourceConnectionId())) {
                this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR.value, "incorrect retry_source_connection_id transport parameter");
            }
        } else if (this.peerTransportParams.getRetrySourceConnectionId() != null) {
            this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR.value, "unexpected retry_source_connection_id transport parameter");
        }
        this.peerAckDelayExponent = transportParameters.getAckDelayExponent();
        this.sender.registerMaxUdpPayloadSize(transportParameters.getMaxUdpPayloadSize());
    }

    private void setZeroRttTransportParameters(TransportParameters rememberedTransportParameters) {
        this.determineIdleTimeout(this.transportParams.getMaxIdleTimeout(), rememberedTransportParameters.getMaxIdleTimeout());
        this.flowController = new FlowControl(Role.Client, rememberedTransportParameters.getInitialMaxData(), rememberedTransportParameters.getInitialMaxStreamDataBidiLocal(), rememberedTransportParameters.getInitialMaxStreamDataBidiRemote(), rememberedTransportParameters.getInitialMaxStreamDataUni(), this.log);
        this.streamManager.setFlowController(this.flowController);
        this.streamManager.setInitialMaxStreamsBidi(rememberedTransportParameters.getInitialMaxStreamsBidi());
        this.streamManager.setInitialMaxStreamsUni(rememberedTransportParameters.getInitialMaxStreamsUni());
        this.connectionIdManager.registerPeerCidLimit(rememberedTransportParameters.getActiveConnectionIdLimit());
    }

    private void verifyVersionNegotiation(TransportParameters transportParameters) {
        assert (this.versionNegotiationStatus == QuicConnectionImpl.VersionNegotiationStatus.VersionChangeUnconfirmed);
        TransportParameters.VersionInformation versionInformation = transportParameters.getVersionInformation();
        if (versionInformation == null || !versionInformation.getChosenVersion().equals(this.quicVersion.getVersion())) {
            this.log.error(String.format("HIERO: connection version: %s, version info: %s", this.quicVersion, versionInformation));
            this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.VERSION_NEGOTIATION_ERROR.value, "Chosen version does not match packet version");
        } else {
            this.versionNegotiationStatus = QuicConnectionImpl.VersionNegotiationStatus.VersionNegotiated;
            this.log.info(String.format("Version negotiation resulted in changing version from %s to %s", this.originalVersion, this.quicVersion));
        }
    }

    private boolean verifyConnectionIds(TransportParameters transportParameters) {
        if (transportParameters.getInitialSourceConnectionId() == null || transportParameters.getOriginalDestinationConnectionId() == null) {
            this.log.error("Missing connection id from server transport parameter");
            if (transportParameters.getInitialSourceConnectionId() == null) {
                this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR.value, "missing initial_source_connection_id transport parameter");
            } else {
                this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR.value, "missing original_destination_connection_id transport parameter");
            }
            return false;
        }
        if (!Arrays.equals(this.connectionIdManager.getCurrentPeerConnectionId(), transportParameters.getInitialSourceConnectionId())) {
            this.log.error("Source connection id does not match corresponding transport parameter");
            this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.PROTOCOL_VIOLATION.value, "initial_source_connection_id transport parameter does not match");
            return false;
        }
        if (!Arrays.equals(this.connectionIdManager.getOriginalDestinationConnectionId(), transportParameters.getOriginalDestinationConnectionId())) {
            this.log.error("Original destination connection id does not match corresponding transport parameter");
            this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.PROTOCOL_VIOLATION.value, "original_destination_connection_id transport parameter does not match");
            return false;
        }
        return true;
    }

    @Override
    public void abortConnection(Throwable error) {
        if (this.connectionState == QuicConnectionImpl.Status.Handshaking) {
            this.handshakeError = error.toString();
        }
        this.connectionState = QuicConnectionImpl.Status.Closing;
        if (error != null) {
            this.log.error("Aborting connection because of error", error);
        }
        this.handshakeFinishedCondition.countDown();
        this.sender.stop();
        this.terminate();
        this.streamManager.abortAll();
    }

    public byte[] nextDestinationConnectionId() {
        byte[] newConnectionId = this.connectionIdManager.nextPeerId();
        if (newConnectionId != null) {
            this.log.debug("Switching to next destination connection id: " + ByteUtils.bytesToHex((byte[])newConnectionId));
        } else {
            this.log.debug("Cannot switch to next destination connection id: no connection id's available");
        }
        return newConnectionId;
    }

    @Override
    protected boolean checkForStatelessResetToken(ByteBuffer data) {
        byte[] tokenCandidate = new byte[16];
        data.position(data.limit() - 16);
        data.get(tokenCandidate);
        boolean isStatelessReset = this.connectionIdManager.isStatelessResetToken(tokenCandidate);
        return isStatelessReset;
    }

    public byte[][] newConnectionIds(int count, int retirePriorTo) {
        byte[][] newConnectionIds = new byte[count][];
        for (int i = 0; i < count; ++i) {
            ConnectionIdInfo cid = this.connectionIdManager.sendNewConnectionId(retirePriorTo);
            if (cid == null) continue;
            newConnectionIds[i] = cid.getConnectionId();
            this.log.debug("New generated source connection id", cid.getConnectionId());
        }
        this.sender.flush();
        return newConnectionIds;
    }

    public void retireDestinationConnectionId(Integer sequenceNumber) {
        this.connectionIdManager.retireConnectionId(sequenceNumber);
    }

    @Override
    protected SenderImpl getSender() {
        return this.sender;
    }

    @Override
    protected GlobalAckGenerator getAckGenerator() {
        return this.ackGenerator;
    }

    protected TlsClientEngine getTlsEngine() {
        return this.tlsEngine;
    }

    @Override
    protected StreamManager getStreamManager() {
        return this.streamManager;
    }

    @Override
    protected int getSourceConnectionIdLength() {
        return this.connectionIdManager.getConnectionIdLength();
    }

    @Override
    public byte[] getSourceConnectionId() {
        return this.connectionIdManager.getCurrentConnectionId();
    }

    public Map<Integer, ConnectionIdInfo> getSourceConnectionIds() {
        return this.connectionIdManager.getAllConnectionIds();
    }

    @Override
    public byte[] getDestinationConnectionId() {
        return this.connectionIdManager.getCurrentPeerConnectionId();
    }

    public Map<Integer, ConnectionIdInfo> getDestinationConnectionIds() {
        return this.connectionIdManager.getAllPeerConnectionIds();
    }

    @Override
    public void setPeerInitiatedStreamCallback(Consumer<QuicStream> streamProcessor) {
        this.streamManager.setPeerInitiatedStreamCallback(streamProcessor);
    }

    @Override
    public long getInitialMaxStreamData() {
        return this.transportParams.getInitialMaxStreamDataBidiLocal();
    }

    @Override
    public void setMaxAllowedBidirectionalStreams(int max) {
        this.transportParams.setInitialMaxStreamsBidi(max);
    }

    @Override
    public void setMaxAllowedUnidirectionalStreams(int max) {
        this.transportParams.setInitialMaxStreamsUni(max);
    }

    @Override
    public void setDefaultStreamReceiveBufferSize(long size) {
        this.transportParams.setInitialMaxStreamData(size);
    }

    public FlowControl getFlowController() {
        return this.flowController;
    }

    public void addNewSessionTicket(NewSessionTicket tlsSessionTicket) {
        if (tlsSessionTicket.hasEarlyDataExtension() && tlsSessionTicket.getEarlyDataMaxSize() != 0xFFFFFFFFL) {
            this.log.error("Invalid quic new session ticket (invalid early data size); ignoring ticket.");
        }
        this.newSessionTickets.add(new QuicSessionTicket(tlsSessionTicket, this.peerTransportParams));
    }

    @Override
    public List<QuicSessionTicket> getNewSessionTickets() {
        return this.newSessionTickets;
    }

    public EarlyDataStatus getEarlyDataStatus() {
        return this.earlyDataStatus;
    }

    public void setEarlyDataStatus(EarlyDataStatus earlyDataStatus) {
        this.earlyDataStatus = earlyDataStatus;
    }

    public URI getUri() {
        try {
            return new URI("//" + this.host + ":" + this.port);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getServerAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    @Override
    public List<X509Certificate> getServerCertificateChain() {
        return this.tlsEngine.getServerCertificateChain();
    }

    @Override
    public boolean isConnected() {
        return this.connectionState == QuicConnectionImpl.Status.Connected;
    }

    protected void trustAnyServerCertificate() {
        X509TrustManager trustAllCerts = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        this.tlsEngine.setTrustManager(trustAllCerts);
        this.tlsEngine.setHostnameVerifier((hostname, serverCertificate) -> true);
    }

    private void enableQuantumReadinessTest(int nrDummyBytes) {
        this.clientHelloEnlargement = nrDummyBytes;
    }

    public static QuicClientConnection.Builder newBuilder() {
        return new BuilderImpl();
    }

    private static class BuilderImpl
    implements QuicClientConnection.Builder {
        private String host;
        private int port;
        private QuicSessionTicket sessionTicket;
        private Version quicVersion = Version.getDefault();
        private Version preferredVersion;
        private Logger log = new NullLogger();
        private String proxyHost;
        private Path secretsFile;
        private Integer initialRtt;
        private Integer connectionIdLength;
        private List<TlsConstants.CipherSuite> cipherSuites = new ArrayList<TlsConstants.CipherSuite>();
        private boolean omitCertificateCheck;
        private Integer quantumReadinessTest;
        private X509Certificate clientCertificate;
        private PrivateKey clientCertificateKey;
        private DatagramSocketFactory datagramSocketFactory = new DefaultDatagramSocketFactory();

        private BuilderImpl() {
        }

        @Override
        public QuicClientConnectionImpl build() throws SocketException, UnknownHostException {
            if (!this.quicVersion.isKnown() || !this.quicVersion.atLeast(Version.IETF_draft_29)) {
                throw new IllegalArgumentException("Quic version " + this.quicVersion + " not supported");
            }
            if (this.host == null) {
                throw new IllegalStateException("Cannot create connection when URI is not set");
            }
            if (this.initialRtt != null && this.initialRtt < 1) {
                throw new IllegalArgumentException("Initial RTT must be larger than 0.");
            }
            if (this.cipherSuites.isEmpty()) {
                this.cipherSuites.add(TlsConstants.CipherSuite.TLS_AES_128_GCM_SHA256);
            }
            QuicClientConnectionImpl quicConnection = new QuicClientConnectionImpl(this.host, this.port, this.sessionTicket, this.quicVersion, this.preferredVersion, this.log, this.proxyHost, this.secretsFile, this.initialRtt, this.connectionIdLength, this.cipherSuites, this.clientCertificate, this.clientCertificateKey, this.datagramSocketFactory);
            if (this.omitCertificateCheck) {
                quicConnection.trustAnyServerCertificate();
            }
            if (this.quantumReadinessTest != null) {
                quicConnection.enableQuantumReadinessTest(this.quantumReadinessTest);
            }
            return quicConnection;
        }

        @Override
        public QuicClientConnection.Builder connectTimeout(Duration duration) {
            return this;
        }

        @Override
        public QuicClientConnection.Builder version(Version version) {
            this.quicVersion = version;
            return this;
        }

        @Override
        public QuicClientConnection.Builder initialVersion(Version version) {
            this.quicVersion = version;
            return this;
        }

        @Override
        public QuicClientConnection.Builder preferredVersion(Version version) {
            this.preferredVersion = version;
            return this;
        }

        @Override
        public QuicClientConnection.Builder logger(Logger log) {
            this.log = log;
            return this;
        }

        @Override
        public QuicClientConnection.Builder sessionTicket(QuicSessionTicket ticket) {
            this.sessionTicket = ticket;
            return this;
        }

        @Override
        public QuicClientConnection.Builder proxy(String host) {
            this.proxyHost = host;
            return this;
        }

        @Override
        public QuicClientConnection.Builder secrets(Path secretsFile) {
            this.secretsFile = secretsFile;
            return this;
        }

        @Override
        public QuicClientConnection.Builder uri(URI uri) {
            this.host = uri.getHost();
            this.port = uri.getPort();
            return this;
        }

        @Override
        public QuicClientConnection.Builder connectionIdLength(int length) {
            if (length < 0 || length > 20) {
                throw new IllegalArgumentException("Connection ID length must between 0 and 20.");
            }
            this.connectionIdLength = length;
            return this;
        }

        @Override
        public QuicClientConnection.Builder initialRtt(int initialRtt) {
            this.initialRtt = initialRtt;
            return this;
        }

        @Override
        public QuicClientConnection.Builder cipherSuite(TlsConstants.CipherSuite cipherSuite) {
            this.cipherSuites.add(cipherSuite);
            return this;
        }

        @Override
        public QuicClientConnection.Builder noServerCertificateCheck() {
            this.omitCertificateCheck = true;
            return this;
        }

        @Override
        public QuicClientConnection.Builder quantumReadinessTest(int nrOfDummyBytes) {
            this.quantumReadinessTest = nrOfDummyBytes;
            return this;
        }

        @Override
        public QuicClientConnection.Builder clientCertificate(X509Certificate certificate) {
            this.clientCertificate = certificate;
            return this;
        }

        @Override
        public QuicClientConnection.Builder clientCertificateKey(PrivateKey privateKey) {
            this.clientCertificateKey = privateKey;
            return this;
        }

        @Override
        public QuicClientConnection.Builder datagramSocketFactory(DatagramSocketFactory datagramSocketFactory) {
            this.datagramSocketFactory = datagramSocketFactory;
            return this;
        }
    }
}

