/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

public class QuicConstants {

    public static enum TransportErrorCode {
        NO_ERROR(0),
        INTERNAL_ERROR(1),
        CONNECTION_REFUSED(2),
        FLOW_CONTROL_ERROR(3),
        STREAM_LIMIT_ERROR(4),
        STREAM_STATE_ERROR(5),
        FINAL_SIZE_ERROR(6),
        FRAME_ENCODING_ERROR(7),
        TRANSPORT_PARAMETER_ERROR(8),
        CONNECTION_ID_LIMIT_ERROR(9),
        PROTOCOL_VIOLATION(10),
        INVALID_TOKEN(11),
        APPLICATION_ERROR(12),
        CRYPTO_BUFFER_EXCEEDED(13),
        KEY_UPDATE_ERROR(14),
        AEAD_LIMIT_REACHED(15),
        NO_VIABLE_PATH(16),
        CRYPTO_ERROR(256),
        VERSION_NEGOTIATION_ERROR(21496);

        public final short value;

        private TransportErrorCode(int value) {
            this.value = (short)value;
        }
    }

    public static enum IpVersion {
        IPv4(4),
        IPv6(6);

        public final byte value;

        private IpVersion(int value) {
            this.value = (byte)value;
        }
    }

    public static enum TransportParameterIdPreDraft17 {
        initial_max_stream_data_bidi_local(0),
        initial_max_data(1),
        initial_max_bidi_streams(2),
        idle_timeout(3),
        preferred_address(4),
        max_packet_size(5),
        stateless_reset_token(6),
        ack_delay_exponent(7),
        initial_max_uni_streams(8),
        disable_migration(9),
        initial_max_stream_data_bidi_remote(10),
        initial_max_stream_data_uni(11),
        max_ack_delay(12),
        original_connection_id(13);

        public final short value;

        private TransportParameterIdPreDraft17(int value) {
            this.value = (short)value;
        }
    }

    public static enum TransportParameterId {
        original_destination_connection_id(0),
        max_idle_timeout(1),
        stateless_reset_token(2),
        max_udp_payload_size(3),
        initial_max_data(4),
        initial_max_stream_data_bidi_local(5),
        initial_max_stream_data_bidi_remote(6),
        initial_max_stream_data_uni(7),
        initial_max_streams_bidi(8),
        initial_max_streams_uni(9),
        ack_delay_exponent(10),
        max_ack_delay(11),
        disable_active_migration(12),
        preferred_address(13),
        active_connection_id_limit(14),
        initial_source_connection_id(15),
        retry_source_connection_id(16),
        version_information(17);

        public final int value;

        private TransportParameterId(int value) {
            this.value = value;
        }
    }
}

