/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.time.Instant;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.luminis.quic.RawPacket;
import net.luminis.quic.log.Logger;

public class Receiver {
    public static final int MAX_DATAGRAM_SIZE = 1500;
    private volatile DatagramSocket socket;
    private final Logger log;
    private final Consumer<Throwable> abortCallback;
    private final Thread receiverThread;
    private final BlockingQueue<RawPacket> receivedPacketsQueue;
    private volatile boolean isClosing = false;
    private volatile boolean changing = false;

    public Receiver(DatagramSocket socket, Logger log, Consumer<Throwable> abortCallback) {
        this.socket = socket;
        this.log = log;
        this.abortCallback = abortCallback;
        this.receiverThread = new Thread(() -> this.run(), "receiver");
        this.receiverThread.setDaemon(true);
        this.receivedPacketsQueue = new LinkedBlockingQueue<RawPacket>();
        try {
            log.debug("Socket receive buffer size: " + socket.getReceiveBufferSize());
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void start() {
        this.receiverThread.start();
    }

    public void shutdown() {
        this.isClosing = true;
        this.receiverThread.interrupt();
    }

    public RawPacket get() throws InterruptedException {
        return this.receivedPacketsQueue.take();
    }

    public boolean hasMore() {
        return !this.receivedPacketsQueue.isEmpty();
    }

    public RawPacket get(int timeout) throws InterruptedException {
        return this.receivedPacketsQueue.poll(timeout, TimeUnit.SECONDS);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run() {
        counter = 0;
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                if (this.isClosing) {
                    this.log.debug("Terminating receive loop");
                    return;
                }
                receiveBuffer = new byte[1500];
                receivedPacket = new DatagramPacket(receiveBuffer, receiveBuffer.length);
                try {
                    this.socket.receive(receivedPacket);
                    timeReceived = Instant.now();
                    rawPacket = new RawPacket(receivedPacket, timeReceived, counter++);
                    this.receivedPacketsQueue.add(rawPacket);
                }
                catch (SocketTimeoutException timeReceived) {
                }
                catch (SocketException socketError) {
                    if (this.changing == false) throw socketError;
                    this.log.debug("Ignoring socket closed exception, because changing socket", socketError);
                    this.changing = false;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            if (!this.isClosing) {
                this.log.error("IOException while receiving datagrams", e);
                this.abortCallback.accept(e);
                return;
            }
            this.log.debug("closing receiver");
            return;
        }
        catch (Throwable fatal) {
            this.log.error("IOException while receiving datagrams", fatal);
            this.abortCallback.accept(fatal);
        }
        ** GOTO lbl-1000
    }

    public void changeAddress(DatagramSocket newSocket) {
        DatagramSocket oldSocket = this.socket;
        this.socket = newSocket;
        this.changing = true;
        oldSocket.close();
    }
}

