/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.cid;

import net.luminis.quic.cid.ConnectionIdStatus;

public class ConnectionIdInfo {
    private final int sequenceNumber;
    private final byte[] connectionId;
    private ConnectionIdStatus connectionIdStatus;
    private final byte[] statelessResetToken;

    ConnectionIdInfo(int sequenceNumber, byte[] connectionId, ConnectionIdStatus status) {
        this.sequenceNumber = sequenceNumber;
        this.connectionId = connectionId;
        this.connectionIdStatus = status;
        this.statelessResetToken = null;
    }

    ConnectionIdInfo(int sequenceNumber, byte[] connectionId, ConnectionIdStatus status, byte[] statelessResetToken) {
        this.sequenceNumber = sequenceNumber;
        this.connectionId = connectionId;
        this.connectionIdStatus = status;
        this.statelessResetToken = statelessResetToken;
    }

    public ConnectionIdInfo addStatelessResetToken(byte[] statelessResetToken) {
        return new ConnectionIdInfo(this.sequenceNumber, this.connectionId, this.connectionIdStatus, statelessResetToken);
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte[] getConnectionId() {
        return this.connectionId;
    }

    public ConnectionIdStatus getConnectionIdStatus() {
        return this.connectionIdStatus;
    }

    public byte[] getStatelessResetToken() {
        return this.statelessResetToken;
    }

    protected void setStatus(ConnectionIdStatus newStatus) {
        this.connectionIdStatus = newStatus;
    }
}

