/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.cid;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.luminis.quic.cid.ConnectionIdInfo;
import net.luminis.quic.cid.ConnectionIdStatus;
import net.luminis.quic.log.Logger;

public abstract class ConnectionIdRegistry {
    public static final int DEFAULT_CID_LENGTH = 8;
    protected final Map<Integer, ConnectionIdInfo> connectionIds = new ConcurrentHashMap<Integer, ConnectionIdInfo>();
    protected volatile byte[] currentConnectionId;
    protected final Logger log;
    private final SecureRandom randomGenerator;
    private final int connectionIdLength;

    public ConnectionIdRegistry(Logger log) {
        this(8, log);
    }

    public ConnectionIdRegistry(Integer cidLength, Logger logger) {
        this.connectionIdLength = cidLength != null ? cidLength : 8;
        this.log = logger;
        this.randomGenerator = new SecureRandom();
        this.currentConnectionId = this.generateConnectionId();
        this.connectionIds.put(0, new ConnectionIdInfo(0, this.currentConnectionId, ConnectionIdStatus.IN_USE));
    }

    public byte[] retireConnectionId(int sequenceNr) {
        if (this.connectionIds.containsKey(sequenceNr)) {
            ConnectionIdInfo cidInfo = this.connectionIds.get(sequenceNr);
            if (cidInfo.getConnectionIdStatus().active()) {
                cidInfo.setStatus(ConnectionIdStatus.RETIRED);
                return cidInfo.getConnectionId();
            }
            return null;
        }
        return null;
    }

    @Deprecated
    public byte[] getCurrent() {
        return this.currentConnectionId;
    }

    public byte[] getActive() {
        return this.connectionIds.entrySet().stream().filter(e -> ((ConnectionIdInfo)e.getValue()).getConnectionIdStatus().active()).map(e -> ((ConnectionIdInfo)e.getValue()).getConnectionId()).findFirst().orElse(null);
    }

    public Map<Integer, ConnectionIdInfo> getAll() {
        return this.connectionIds;
    }

    protected int currentIndex() {
        return this.connectionIds.entrySet().stream().filter(entry -> Arrays.equals(((ConnectionIdInfo)entry.getValue()).getConnectionId(), this.currentConnectionId)).mapToInt(entry -> (Integer)entry.getKey()).findFirst().orElseThrow();
    }

    protected byte[] generateConnectionId() {
        byte[] connectionId = new byte[this.connectionIdLength];
        this.randomGenerator.nextBytes(connectionId);
        return connectionId;
    }

    public int getConnectionIdlength() {
        return this.connectionIdLength;
    }

    public List<byte[]> getActiveConnectionIds() {
        return this.connectionIds.values().stream().filter(cid -> cid.getConnectionIdStatus().active()).map(info -> info.getConnectionId()).collect(Collectors.toList());
    }
}

