/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final String threadBaseName;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    public DaemonThreadFactory(String threadBaseName) {
        this.threadBaseName = threadBaseName;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.threadBaseName + "-" + this.threadNumber.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    }
}

