/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.crypto;

import at.favre.lib.crypto.HKDF;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.luminis.quic.Role;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.Aead;
import net.luminis.quic.log.Logger;

public abstract class BaseAeadImpl
implements Aead {
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final String QUIC_V1_KDF_LABEL_PREFIX = "quic ";
    public static final String QUIC_V2_KDF_LABEL_PREFIX = "quicv2 ";
    private final Role nodeRole;
    private final Logger log;
    private final Version quicVersion;
    private byte[] trafficSecret;
    private byte[] newApplicationTrafficSecret;
    protected byte[] writeKey;
    protected byte[] newKey;
    protected byte[] writeIV;
    protected byte[] newIV;
    protected byte[] hp;
    protected Cipher hpCipher;
    protected SecretKeySpec writeKeySpec;
    protected SecretKeySpec newWriteKeySpec;
    protected Cipher writeCipher;
    private int keyUpdateCounter = 0;
    protected boolean possibleKeyUpdateInProgresss = false;
    private volatile Aead peerAead;

    public BaseAeadImpl(Version quicVersion, Role nodeRole, Logger log) {
        this.nodeRole = nodeRole;
        this.log = log;
        this.quicVersion = quicVersion;
    }

    public BaseAeadImpl(Version quicVersion, byte[] initialSecret, Role nodeRole, Logger log) {
        this.nodeRole = nodeRole;
        this.log = log;
        this.quicVersion = quicVersion;
        byte[] initialNodeSecret = this.hkdfExpandLabel(quicVersion, initialSecret, nodeRole == Role.Client ? "client in" : "server in", "", this.getHashLength());
        log.secret(nodeRole + " initial secret", initialNodeSecret);
        this.computeKeys(initialNodeSecret, true, true);
    }

    protected abstract short getKeyLength();

    protected abstract short getHashLength();

    protected abstract HKDF getHKDF();

    @Override
    public synchronized void computeKeys(byte[] trafficSecret) {
        this.trafficSecret = trafficSecret;
        this.computeKeys(trafficSecret, true, true);
    }

    @Override
    public synchronized void computeKeyUpdate(boolean selfInitiated) {
        String prefix = this.quicVersion.isV2() ? QUIC_V2_KDF_LABEL_PREFIX : QUIC_V1_KDF_LABEL_PREFIX;
        this.newApplicationTrafficSecret = this.hkdfExpandLabel(this.quicVersion, this.trafficSecret, prefix + "ku", "", (short)32);
        this.log.secret("Updated ApplicationTrafficSecret (" + (selfInitiated ? "self" : "peer") + "): ", this.newApplicationTrafficSecret);
        this.computeKeys(this.newApplicationTrafficSecret, false, selfInitiated);
        if (selfInitiated) {
            this.trafficSecret = this.newApplicationTrafficSecret;
            ++this.keyUpdateCounter;
            this.newApplicationTrafficSecret = null;
        }
    }

    @Override
    public synchronized void confirmKeyUpdateIfInProgress() {
        if (this.possibleKeyUpdateInProgresss) {
            this.log.info("Installing updated keys (initiated by peer)");
            this.trafficSecret = this.newApplicationTrafficSecret;
            this.writeKey = this.newKey;
            this.writeKeySpec = null;
            this.writeIV = this.newIV;
            ++this.keyUpdateCounter;
            this.newApplicationTrafficSecret = null;
            this.possibleKeyUpdateInProgresss = false;
            this.newKey = null;
            this.newIV = null;
            this.checkPeerKeys();
        }
    }

    @Override
    public int getKeyUpdateCounter() {
        return this.keyUpdateCounter;
    }

    private void checkPeerKeys() {
        if (this.peerAead.getKeyUpdateCounter() < this.keyUpdateCounter) {
            this.log.debug("Keys out of sync; updating keys for peer");
            this.peerAead.computeKeyUpdate(true);
        }
    }

    @Override
    public synchronized void cancelKeyUpdateIfInProgress() {
        if (this.possibleKeyUpdateInProgresss) {
            this.log.info("Discarding updated keys (initiated by peer)");
            this.newApplicationTrafficSecret = null;
            this.possibleKeyUpdateInProgresss = false;
            this.newKey = null;
            this.newIV = null;
        }
    }

    private void computeKeys(byte[] secret, boolean includeHP, boolean replaceKeys) {
        String labelPrefix = this.quicVersion.isV2() ? QUIC_V2_KDF_LABEL_PREFIX : QUIC_V1_KDF_LABEL_PREFIX;
        byte[] key = this.hkdfExpandLabel(this.quicVersion, secret, labelPrefix + "key", "", this.getKeyLength());
        if (replaceKeys) {
            this.writeKey = key;
            this.writeKeySpec = null;
        } else {
            this.newKey = key;
            this.newWriteKeySpec = null;
        }
        this.log.secret(this.nodeRole + " key", key);
        byte[] iv = this.hkdfExpandLabel(this.quicVersion, secret, labelPrefix + "iv", "", (short)12);
        if (replaceKeys) {
            this.writeIV = iv;
        } else {
            this.newIV = iv;
        }
        this.log.secret(this.nodeRole + " iv", iv);
        if (includeHP) {
            this.hp = this.hkdfExpandLabel(this.quicVersion, secret, labelPrefix + "hp", "", this.getKeyLength());
            this.log.secret(this.nodeRole + " hp", this.hp);
        }
    }

    byte[] hkdfExpandLabel(Version quicVersion, byte[] secret, String label, String context, short length) {
        byte[] prefix = "tls13 ".getBytes(ISO_8859_1);
        ByteBuffer hkdfLabel = ByteBuffer.allocate(3 + prefix.length + label.getBytes(ISO_8859_1).length + 1 + context.getBytes(ISO_8859_1).length);
        hkdfLabel.putShort(length);
        hkdfLabel.put((byte)(prefix.length + label.getBytes().length));
        hkdfLabel.put(prefix);
        hkdfLabel.put(label.getBytes(ISO_8859_1));
        hkdfLabel.put((byte)context.getBytes(ISO_8859_1).length);
        hkdfLabel.put(context.getBytes(ISO_8859_1));
        HKDF hkdf = this.getHKDF();
        return hkdf.expand(secret, hkdfLabel.array(), (int)length);
    }

    @Override
    public byte[] getTrafficSecret() {
        return this.trafficSecret;
    }

    public byte[] getWriteKey() {
        if (this.possibleKeyUpdateInProgresss) {
            return this.newKey;
        }
        return this.writeKey;
    }

    @Override
    public byte[] getWriteIV() {
        if (this.possibleKeyUpdateInProgresss) {
            return this.newIV;
        }
        return this.writeIV;
    }

    public byte[] getHp() {
        return this.hp;
    }

    public abstract Cipher getHeaderProtectionCipher();

    public abstract SecretKeySpec getWriteKeySpec();

    public abstract Cipher getWriteCipher();

    @Override
    public short getKeyPhase() {
        return (short)(this.keyUpdateCounter % 2);
    }

    @Override
    public void checkKeyPhase(short keyPhaseBit) {
        if (this.keyUpdateCounter % 2 != keyPhaseBit) {
            if (this.newKey == null) {
                this.computeKeyUpdate(false);
                this.log.secret("Computed new (updated) key", this.newKey);
                this.log.secret("Computed new (updated) iv", this.newIV);
            }
            this.log.info("Received key phase does not match current => possible key update in progress");
            this.possibleKeyUpdateInProgresss = true;
        }
    }

    @Override
    public void setPeerAead(Aead peerAead) {
        this.peerAead = peerAead;
    }
}

