/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.crypto;

import at.favre.lib.crypto.HKDF;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.Role;
import net.luminis.quic.Version;
import net.luminis.quic.VersionHolder;
import net.luminis.quic.crypto.Aead;
import net.luminis.quic.crypto.Aes128Gcm;
import net.luminis.quic.crypto.Aes256Gcm;
import net.luminis.quic.crypto.BaseAeadImpl;
import net.luminis.quic.crypto.ChaCha20;
import net.luminis.quic.log.Logger;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TrafficSecrets;
import net.luminis.tls.util.ByteUtils;

public class ConnectionSecrets {
    private TlsConstants.CipherSuite selectedCipherSuite;
    public static final byte[] STATIC_SALT_DRAFT_29 = new byte[]{-81, -65, -20, 40, -103, -109, -46, 76, -98, -105, -122, -15, -100, 97, 17, -32, 67, -112, -88, -103};
    public static final byte[] STATIC_SALT_V1 = new byte[]{56, 118, 44, -9, -11, 89, 52, -77, 77, 23, -102, -26, -92, -56, 12, -83, -52, -69, 127, 10};
    public static final byte[] STATIC_SALT_V2 = new byte[]{13, -19, -29, -34, -9, 0, -90, -37, -127, -109, -127, -66, 110, 38, -99, -53, -7, -67, 46, -39};
    private final VersionHolder quicVersion;
    private final Role ownRole;
    private Logger log;
    private byte[] clientRandom;
    private Aead[] clientSecrets = new Aead[EncryptionLevel.values().length];
    private Aead[] serverSecrets = new Aead[EncryptionLevel.values().length];
    private boolean writeSecretsToFile;
    private Path wiresharkSecretsFile;
    private byte[] originalDestinationConnectionId;

    public ConnectionSecrets(VersionHolder quicVersion, Role role, Path wiresharksecrets, Logger log) {
        this.quicVersion = quicVersion;
        this.ownRole = role;
        this.log = log;
        if (wiresharksecrets != null) {
            this.wiresharkSecretsFile = wiresharksecrets;
            try {
                Files.deleteIfExists(this.wiresharkSecretsFile);
                Files.createFile(this.wiresharkSecretsFile, new FileAttribute[0]);
                this.writeSecretsToFile = true;
            }
            catch (IOException e) {
                log.error("Initializing (creating/truncating) secrets file '" + this.wiresharkSecretsFile + "' failed", e);
            }
        }
    }

    public synchronized void computeInitialKeys(byte[] destConnectionId) {
        this.originalDestinationConnectionId = destConnectionId;
        Version actualVersion = this.quicVersion.getVersion();
        byte[] initialSecret = this.computeInitialSecret(actualVersion);
        this.log.secret("Initial secret", initialSecret);
        this.clientSecrets[EncryptionLevel.Initial.ordinal()] = new Aes128Gcm(actualVersion, initialSecret, Role.Client, this.log);
        this.serverSecrets[EncryptionLevel.Initial.ordinal()] = new Aes128Gcm(actualVersion, initialSecret, Role.Server, this.log);
    }

    public Aead getInitialPeerSecretsForVersion(Version version) {
        return new Aes128Gcm(version, this.computeInitialSecret(version), this.ownRole.other(), this.log);
    }

    private byte[] computeInitialSecret(Version actualVersion) {
        HKDF hkdf = HKDF.fromHmacSha256();
        byte[] initialSalt = actualVersion.isV1() ? STATIC_SALT_V1 : (actualVersion.isV2() ? STATIC_SALT_V2 : STATIC_SALT_DRAFT_29);
        return hkdf.extract(initialSalt, this.originalDestinationConnectionId);
    }

    public void recomputeInitialKeys() {
        this.computeInitialKeys(this.originalDestinationConnectionId);
    }

    public synchronized void computeEarlySecrets(TrafficSecrets secrets, TlsConstants.CipherSuite cipherSuite, Version originalVersion) {
        this.createKeys(EncryptionLevel.ZeroRTT, cipherSuite, originalVersion);
        byte[] earlySecret = secrets.getClientEarlyTrafficSecret();
        this.clientSecrets[EncryptionLevel.ZeroRTT.ordinal()].computeKeys(earlySecret);
    }

    private void createKeys(EncryptionLevel level, TlsConstants.CipherSuite selectedCipherSuite, Version version) {
        BaseAeadImpl serverHandshakeSecrets;
        BaseAeadImpl clientHandshakeSecrets;
        if (selectedCipherSuite == TlsConstants.CipherSuite.TLS_AES_128_GCM_SHA256) {
            clientHandshakeSecrets = new Aes128Gcm(version, Role.Client, this.log);
            serverHandshakeSecrets = new Aes128Gcm(version, Role.Server, this.log);
        } else if (selectedCipherSuite == TlsConstants.CipherSuite.TLS_AES_256_GCM_SHA384) {
            clientHandshakeSecrets = new Aes256Gcm(version, Role.Client, this.log);
            serverHandshakeSecrets = new Aes256Gcm(version, Role.Server, this.log);
        } else if (selectedCipherSuite == TlsConstants.CipherSuite.TLS_CHACHA20_POLY1305_SHA256) {
            clientHandshakeSecrets = new ChaCha20(version, Role.Client, this.log);
            serverHandshakeSecrets = new ChaCha20(version, Role.Server, this.log);
        } else {
            throw new IllegalStateException("unsupported cipher suite " + selectedCipherSuite);
        }
        this.clientSecrets[level.ordinal()] = clientHandshakeSecrets;
        if (level != EncryptionLevel.ZeroRTT) {
            this.serverSecrets[level.ordinal()] = serverHandshakeSecrets;
        }
        clientHandshakeSecrets.setPeerAead(serverHandshakeSecrets);
        serverHandshakeSecrets.setPeerAead(clientHandshakeSecrets);
    }

    public synchronized void computeHandshakeSecrets(TrafficSecrets secrets, TlsConstants.CipherSuite selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
        this.createKeys(EncryptionLevel.Handshake, selectedCipherSuite, this.quicVersion.getVersion());
        byte[] clientHandshakeTrafficSecret = secrets.getClientHandshakeTrafficSecret();
        this.log.secret("ClientHandshakeTrafficSecret: ", clientHandshakeTrafficSecret);
        this.clientSecrets[EncryptionLevel.Handshake.ordinal()].computeKeys(clientHandshakeTrafficSecret);
        byte[] serverHandshakeTrafficSecret = secrets.getServerHandshakeTrafficSecret();
        this.log.secret("ServerHandshakeTrafficSecret: ", serverHandshakeTrafficSecret);
        this.serverSecrets[EncryptionLevel.Handshake.ordinal()].computeKeys(serverHandshakeTrafficSecret);
        if (this.writeSecretsToFile) {
            this.appendToFile("HANDSHAKE_TRAFFIC_SECRET", EncryptionLevel.Handshake);
        }
    }

    public synchronized void computeApplicationSecrets(TrafficSecrets secrets) {
        this.createKeys(EncryptionLevel.App, this.selectedCipherSuite, this.quicVersion.getVersion());
        byte[] clientApplicationTrafficSecret = secrets.getClientApplicationTrafficSecret();
        this.log.secret("ClientApplicationTrafficSecret: ", clientApplicationTrafficSecret);
        this.clientSecrets[EncryptionLevel.App.ordinal()].computeKeys(clientApplicationTrafficSecret);
        byte[] serverApplicationTrafficSecret = secrets.getServerApplicationTrafficSecret();
        this.log.secret("ServerApplicationTrafficSecret: ", serverApplicationTrafficSecret);
        this.serverSecrets[EncryptionLevel.App.ordinal()].computeKeys(serverApplicationTrafficSecret);
        if (this.writeSecretsToFile) {
            this.appendToFile("TRAFFIC_SECRET_0", EncryptionLevel.App);
        }
    }

    private void appendToFile(String label, EncryptionLevel level) {
        ArrayList<CallSite> content = new ArrayList<CallSite>();
        content.add((CallSite)((Object)("CLIENT_" + label + " " + ByteUtils.bytesToHex((byte[])this.clientRandom) + " " + ByteUtils.bytesToHex((byte[])this.clientSecrets[level.ordinal()].getTrafficSecret()))));
        content.add((CallSite)((Object)("SERVER_" + label + " " + ByteUtils.bytesToHex((byte[])this.clientRandom) + " " + ByteUtils.bytesToHex((byte[])this.serverSecrets[level.ordinal()].getTrafficSecret()))));
        try {
            Files.write(this.wiresharkSecretsFile, content, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            this.log.error("Writing secrets to file '" + this.wiresharkSecretsFile + "' failed", e);
            this.writeSecretsToFile = false;
        }
    }

    public void setClientRandom(byte[] clientRandom) {
        this.clientRandom = clientRandom;
    }

    public synchronized Aead getClientAead(EncryptionLevel encryptionLevel) {
        return this.clientSecrets[encryptionLevel.ordinal()];
    }

    public synchronized Aead getServerAead(EncryptionLevel encryptionLevel) {
        return this.serverSecrets[encryptionLevel.ordinal()];
    }

    public synchronized Aead getPeerAead(EncryptionLevel encryptionLevel) {
        return this.ownRole == Role.Client ? this.serverSecrets[encryptionLevel.ordinal()] : this.clientSecrets[encryptionLevel.ordinal()];
    }

    public synchronized Aead getOwnAead(EncryptionLevel encryptionLevel) {
        return this.ownRole == Role.Client ? this.clientSecrets[encryptionLevel.ordinal()] : this.serverSecrets[encryptionLevel.ordinal()];
    }
}

