/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.ack.Range;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class AckFrame
extends QuicFrame {
    public static final int MAX_FRAME_SIZE = 1000;
    private byte[] frameBytes;
    private long largestAcknowledged;
    private int ackDelay;
    private List<Range> acknowledgedRanges;
    private int delayScale = 8;
    private String stringRepresentation = null;

    public AckFrame() {
    }

    public AckFrame(long packetNumber) {
        this(Version.getDefault(), List.of(new Range(packetNumber)), 0);
    }

    public AckFrame(Range ackRange) {
        this(Version.getDefault(), List.of(ackRange), 0);
    }

    public AckFrame(List<Range> ackRanges) {
        this(Version.getDefault(), ackRanges, 0);
    }

    public AckFrame(Version quicVersion, List<Range> ackRanges, int ackDelay) {
        if (!Range.validRangeList(ackRanges)) {
            throw new IllegalArgumentException("invalid range");
        }
        this.acknowledgedRanges = List.copyOf(ackRanges);
        this.ackDelay = ackDelay * 1000 / this.delayScale;
        Iterator<Range> rangeIterator = ackRanges.iterator();
        Range firstRange = rangeIterator.next();
        this.largestAcknowledged = firstRange.getLargest();
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        buffer.put((byte)2);
        VariableLengthInteger.encode(this.largestAcknowledged, buffer);
        VariableLengthInteger.encode(ackDelay, buffer);
        VariableLengthInteger.encode(ackRanges.size() - 1, buffer);
        VariableLengthInteger.encode(firstRange.size() - 1, buffer);
        long smallest = firstRange.getSmallest();
        while (rangeIterator.hasNext()) {
            Range next = rangeIterator.next();
            int gap = (int)(smallest - next.getLargest() - 2L);
            int ackRangeLength = next.size() - 1;
            VariableLengthInteger.encode(gap, buffer);
            VariableLengthInteger.encode(ackRangeLength, buffer);
            smallest = next.getSmallest();
        }
        this.frameBytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(this.frameBytes);
    }

    @Override
    public int getFrameLength() {
        if (this.frameBytes != null) {
            return this.frameBytes.length;
        }
        throw new IllegalStateException("frame length not known for parsed frames");
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put(this.frameBytes);
    }

    public AckFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        log.debug("Parsing AckFrame");
        this.acknowledgedRanges = new ArrayList<Range>();
        byte frameType = buffer.get();
        this.largestAcknowledged = VariableLengthInteger.parseLong(buffer);
        this.ackDelay = (int)VariableLengthInteger.parseLong(buffer);
        int ackBlockCount = (int)VariableLengthInteger.parseLong(buffer);
        long currentSmallest = this.largestAcknowledged;
        currentSmallest -= (long)(this.addAcknowledgeRange(this.largestAcknowledged, 1 + VariableLengthInteger.parse(buffer)) - 1);
        for (int i = 0; i < ackBlockCount; ++i) {
            int gapSize = VariableLengthInteger.parse(buffer) + 1;
            int contiguousPacketsPreceding = VariableLengthInteger.parse(buffer) + 1;
            currentSmallest -= (long)(gapSize + this.addAcknowledgeRange(currentSmallest - (long)gapSize - 1L, contiguousPacketsPreceding));
        }
        if (frameType == 3) {
            VariableLengthInteger.parseLong(buffer);
            VariableLengthInteger.parseLong(buffer);
            VariableLengthInteger.parseLong(buffer);
        }
        return this;
    }

    private int addAcknowledgeRange(long largestOfRange, int rangeSize) {
        this.acknowledgedRanges.add(new Range(largestOfRange - (long)rangeSize + 1L, largestOfRange));
        return rangeSize;
    }

    public Stream<Long> getAckedPacketNumbers() {
        return this.acknowledgedRanges.stream().flatMap(r -> r.stream());
    }

    public List<Range> getAcknowledgedRanges() {
        return this.acknowledgedRanges;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.acknowledgedRanges.stream().map(r -> r.size() == 1 ? "" + r.getLargest() : r.getLargest() + "-" + r.getSmallest()).collect(Collectors.joining(","));
        }
        return "AckFrame[" + this.stringRepresentation + "|\u0394" + this.ackDelay * this.delayScale / 1000 + "]";
    }

    @Override
    public boolean isAckEliciting() {
        return false;
    }

    public long getLargestAcknowledged() {
        return this.largestAcknowledged;
    }

    public int getAckDelay() {
        return this.ackDelay * this.delayScale / 1000;
    }

    public void setDelayExponent(int exponent) {
        this.delayScale = (int)Math.pow(2.0, exponent);
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

