/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class MaxStreamsFrame
extends QuicFrame {
    private long maxStreams;
    private boolean appliesToBidirectional;

    public MaxStreamsFrame(long maxStreams, boolean appliesToBidirectional) {
        this.maxStreams = maxStreams;
        this.appliesToBidirectional = appliesToBidirectional;
    }

    public MaxStreamsFrame() {
    }

    public MaxStreamsFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        byte frameType = buffer.get();
        if (frameType != 18 && frameType != 19) {
            throw new RuntimeException();
        }
        this.appliesToBidirectional = frameType == 18;
        this.maxStreams = VariableLengthInteger.parseLong(buffer);
        return this;
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.maxStreams);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)(this.appliesToBidirectional ? 18 : 19));
        VariableLengthInteger.encode(this.maxStreams, buffer);
    }

    public String toString() {
        return "MaxStreamsFrame[" + (this.appliesToBidirectional ? "B" : "U") + "," + this.maxStreams + "]";
    }

    public long getMaxStreams() {
        return this.maxStreams;
    }

    public boolean isAppliesToBidirectional() {
        return this.appliesToBidirectional;
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

