/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Random;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.tls.util.ByteUtils;

public class NewConnectionIdFrame
extends QuicFrame {
    private Version quicVersion;
    private int sequenceNr;
    private int retirePriorTo;
    private byte[] connectionId;
    private static Random random = new Random();
    private byte[] statelessResetToken;

    public NewConnectionIdFrame(Version quicVersion) {
        this.quicVersion = quicVersion;
    }

    public NewConnectionIdFrame(Version quicVersion, int sequenceNr, int retirePriorTo, byte[] newSourceConnectionId) {
        this.quicVersion = quicVersion;
        this.sequenceNr = sequenceNr;
        this.retirePriorTo = retirePriorTo;
        this.connectionId = newSourceConnectionId;
        this.statelessResetToken = new byte[16];
        random.nextBytes(this.statelessResetToken);
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.sequenceNr) + VariableLengthInteger.bytesNeeded(this.retirePriorTo) + 1 + this.connectionId.length + 16;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)24);
        VariableLengthInteger.encode(this.sequenceNr, buffer);
        VariableLengthInteger.encode(this.retirePriorTo, buffer);
        buffer.put((byte)this.connectionId.length);
        buffer.put(this.connectionId);
        buffer.put(this.statelessResetToken);
    }

    public NewConnectionIdFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        buffer.get();
        this.sequenceNr = VariableLengthInteger.parse(buffer);
        this.retirePriorTo = VariableLengthInteger.parse(buffer);
        byte connectionIdLength = buffer.get();
        this.connectionId = new byte[connectionIdLength];
        buffer.get(this.connectionId);
        this.statelessResetToken = new byte[16];
        buffer.get(this.statelessResetToken);
        return this;
    }

    public String toString() {
        return "NewConnectionIdFrame[" + this.sequenceNr + ",<" + this.retirePriorTo + "|" + ByteUtils.bytesToHex((byte[])this.connectionId) + "|" + ByteUtils.bytesToHex((byte[])this.statelessResetToken) + "]";
    }

    public int getSequenceNr() {
        return this.sequenceNr;
    }

    public byte[] getConnectionId() {
        return this.connectionId;
    }

    public int getRetirePriorTo() {
        return this.retirePriorTo;
    }

    public byte[] getStatelessResetToken() {
        return this.statelessResetToken;
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

