/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class ResetStreamFrame
extends QuicFrame {
    private int streamId;
    private long errorCode;
    private long finalSize;

    public static int getMaximumFrameSize(int streamId, long errorCode) {
        int maxFinalSizeLength = 8;
        return 1 + VariableLengthInteger.bytesNeeded(streamId) + VariableLengthInteger.bytesNeeded(errorCode) + maxFinalSizeLength;
    }

    public ResetStreamFrame() {
    }

    public ResetStreamFrame(int streamId, long errorCode, long finalSize) {
        this.streamId = streamId;
        this.errorCode = errorCode;
        this.finalSize = finalSize;
    }

    public ResetStreamFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        byte frameType = buffer.get();
        this.streamId = VariableLengthInteger.parse(buffer);
        this.errorCode = VariableLengthInteger.parseLong(buffer);
        this.finalSize = VariableLengthInteger.parseLong(buffer);
        return this;
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.streamId) + VariableLengthInteger.bytesNeeded(this.errorCode) + VariableLengthInteger.bytesNeeded(this.finalSize);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)4);
        VariableLengthInteger.encode(this.streamId, buffer);
        VariableLengthInteger.encode(this.errorCode, buffer);
        VariableLengthInteger.encode(this.finalSize, buffer);
    }

    public String toString() {
        return "ResetStreamFrame[" + this.streamId + "|" + this.errorCode + "|" + this.finalSize + "]";
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }

    public int getStreamId() {
        return this.streamId;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public long getFinalSize() {
        return this.finalSize;
    }
}

