/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class StopSendingFrame
extends QuicFrame {
    private int streamId;
    private long errorCode;

    public StopSendingFrame(Version quicVersion) {
    }

    public StopSendingFrame(Version quicVersion, Integer streamId, Long errorCode) {
        this.streamId = streamId;
        this.errorCode = errorCode;
    }

    public StopSendingFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        buffer.get();
        this.streamId = VariableLengthInteger.parse(buffer);
        this.errorCode = VariableLengthInteger.parseLong(buffer);
        return this;
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.streamId) + VariableLengthInteger.bytesNeeded(this.errorCode);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)5);
        VariableLengthInteger.encode(this.streamId, buffer);
        VariableLengthInteger.encode(this.errorCode, buffer);
    }

    public String toString() {
        return "StopSendingFrame[" + this.streamId + ":" + this.errorCode + "]";
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }

    public int getStreamId() {
        return this.streamId;
    }

    public long getErrorCode() {
        return this.errorCode;
    }
}

