/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class StreamDataBlockedFrame
extends QuicFrame {
    private int streamId;
    private long streamDataLimit;

    public StreamDataBlockedFrame() {
    }

    public StreamDataBlockedFrame(Version quicVersion, int streamId, long streamDataLimit) {
        this.streamId = streamId;
        this.streamDataLimit = streamDataLimit;
    }

    public StreamDataBlockedFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        byte frameType = buffer.get();
        this.streamId = VariableLengthInteger.parse(buffer);
        this.streamDataLimit = VariableLengthInteger.parseLong(buffer);
        return this;
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.streamId) + VariableLengthInteger.bytesNeeded(this.streamDataLimit);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)21);
        VariableLengthInteger.encode(this.streamId, buffer);
        VariableLengthInteger.encode(this.streamDataLimit, buffer);
    }

    public static int getMaxSize(int streamId) {
        return 1 + VariableLengthInteger.bytesNeeded(streamId) + 8;
    }

    public String toString() {
        return "StreamDataBlockedFrame[" + this.streamId + "|" + this.streamDataLimit + "]";
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }

    public int getStreamId() {
        return this.streamId;
    }

    public long getStreamDataLimit() {
        return this.streamDataLimit;
    }
}

