/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class StreamsBlockedFrame
extends QuicFrame {
    private boolean bidirectional;
    private long streamLimit;

    public StreamsBlockedFrame() {
    }

    public StreamsBlockedFrame(Version quicVersion, boolean bidirectional, int streamLimit) {
        this.bidirectional = bidirectional;
        this.streamLimit = streamLimit;
    }

    public StreamsBlockedFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        byte frameType = buffer.get();
        this.bidirectional = frameType == 22;
        this.streamLimit = VariableLengthInteger.parseLong(buffer);
        return this;
    }

    @Override
    public int getFrameLength() {
        return 1 + VariableLengthInteger.bytesNeeded(this.streamLimit);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put(this.bidirectional ? (byte)22 : 23);
        VariableLengthInteger.encode(this.streamLimit, buffer);
    }

    public String toString() {
        return "StreamsBlockedFrame[" + (this.bidirectional ? "B" : "U") + "|" + this.streamLimit + "]";
    }

    @Override
    public void accept(FrameProcessor frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public long getStreamLimit() {
        return this.streamLimit;
    }
}

