/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.log;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.qlog.NullQLog;
import net.luminis.quic.qlog.QLog;
import net.luminis.tls.util.ByteUtils;

public abstract class BaseLogger
implements Logger {
    public static final String TIME_FORMAT_SHORT = "mm:ss.SSS";
    private static final String TIME_FORMAT_LONG = "yy-MM-dd'T'HH:mm:ss.SSS";
    private volatile boolean logDebug = false;
    private volatile boolean logRawBytes = false;
    private volatile boolean logDecrypted = false;
    private volatile boolean logSecrets = false;
    private volatile boolean logPackets = false;
    private volatile boolean logInfo = false;
    private volatile boolean logWarning = false;
    private volatile boolean logStats = false;
    private volatile boolean logRecovery = false;
    private volatile boolean logCongestionControl = false;
    private volatile boolean logFlowControl = false;
    private volatile boolean useRelativeTime = false;
    private volatile DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("mm:ss.SSS");
    private Instant start;

    @Override
    public void logDebug(boolean enabled) {
        this.logDebug = enabled;
    }

    @Override
    public void logRaw(boolean enabled) {
        this.logRawBytes = enabled;
    }

    @Override
    public void logDecrypted(boolean enabled) {
        this.logDecrypted = enabled;
    }

    @Override
    public void logSecrets(boolean enabled) {
        this.logSecrets = enabled;
    }

    @Override
    public void logPackets(boolean enabled) {
        this.logPackets = enabled;
    }

    @Override
    public void logInfo(boolean enabled) {
        this.logInfo = enabled;
    }

    @Override
    public void logWarning(boolean enabled) {
        this.logWarning = enabled;
    }

    @Override
    public void logStats(boolean enabled) {
        this.logStats = enabled;
    }

    @Override
    public void logRecovery(boolean enabled) {
        this.logRecovery = enabled;
    }

    @Override
    public boolean logRecovery() {
        return this.logRecovery;
    }

    @Override
    public void logCongestionControl(boolean enabled) {
        this.logCongestionControl = enabled;
    }

    @Override
    public boolean logFlowControl() {
        return this.logFlowControl;
    }

    @Override
    public void logFlowControl(boolean enabled) {
        this.logFlowControl = enabled;
    }

    @Override
    public void useRelativeTime(boolean enabled) {
        this.useRelativeTime = enabled;
    }

    @Override
    public void timeFormat(Logger.TimeFormat format) {
        switch (format) {
            case Short: {
                this.timeFormatter = DateTimeFormatter.ofPattern(TIME_FORMAT_SHORT);
                break;
            }
            case Long: {
                this.timeFormatter = DateTimeFormatter.ofPattern(TIME_FORMAT_LONG);
            }
        }
    }

    @Override
    public void debug(String message) {
        if (this.logDebug) {
            this.log(message);
        }
    }

    @Override
    public void debug(String message, Exception error) {
        if (this.logDebug) {
            this.log(message, error);
        }
    }

    @Override
    public void debugWithHexBlock(String message, byte[] data) {
        if (this.logDebug) {
            this.logWithHexDump(message + " (" + data.length + "): ", data, data.length);
        }
    }

    @Override
    public void debugWithHexBlock(String message, byte[] data, int length) {
        if (this.logDebug) {
            this.logWithHexDump(message + " (" + data.length + "): ", data, length);
        }
    }

    @Override
    public void debug(String message, byte[] data) {
        if (this.logDebug) {
            this.log(message + " (" + data.length + "): " + this.byteToHex(data));
        }
    }

    @Override
    public void warn(String message) {
        if (this.logWarning) {
            this.log(this.formatTime() + " " + message);
        }
    }

    @Override
    public void info(String message) {
        if (this.logInfo) {
            this.log(this.formatTime() + " " + message);
        }
    }

    @Override
    public void info(String message, byte[] data) {
        if (this.logInfo) {
            this.log(this.formatTime() + " " + message + " (" + data.length + "): " + ByteUtils.bytesToHex((byte[])data));
        }
    }

    @Override
    public void received(Instant timeReceived, int datagram, QuicPacket packet) {
        if (this.logPackets) {
            this.log(this.formatTime(timeReceived) + " <- (" + datagram + ") " + packet);
        }
    }

    @Override
    public void received(Instant timeReceived, int datagram, EncryptionLevel encryptionLevel, byte[] dcid, byte[] scid) {
        if (this.logPackets) {
            this.log(this.formatTime(timeReceived) + " <- (" + datagram + ") Packet " + encryptionLevel.name().charAt(0) + "|.|L|" + ByteUtils.bytesToHex((byte[])dcid) + "|" + ByteUtils.bytesToHex((byte[])scid));
        }
    }

    @Override
    public void receivedPacketInfo(String info) {
        if (this.logPackets) {
            int indent = this.formatTime(Instant.now()).length();
            this.log(" ".repeat(indent) + " -< " + info);
        }
    }

    @Override
    public void sentPacketInfo(String info) {
        if (this.logPackets) {
            int indent = this.formatTime(Instant.now()).length();
            this.log(" ".repeat(indent) + " >- " + info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sent(Instant sent, QuicPacket packet) {
        BaseLogger baseLogger = this;
        synchronized (baseLogger) {
            if (this.useRelativeTime && this.start == null) {
                this.start = sent;
            }
        }
        if (this.logPackets) {
            this.log(this.formatTime(sent) + " -> " + packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sent(Instant sent, List<QuicPacket> packets) {
        BaseLogger baseLogger = this;
        synchronized (baseLogger) {
            if (this.useRelativeTime && this.start == null) {
                this.start = sent;
            }
        }
        if (this.logPackets) {
            if (packets.size() == 1) {
                this.log(this.formatTime(sent) + " -> " + packets.get(0));
            } else {
                this.log(this.formatTime(sent) + " -> " + packets);
            }
        }
    }

    @Override
    public void secret(String message, byte[] secret) {
        if (this.logSecrets) {
            this.log(message + ": " + this.byteToHex(secret));
        }
    }

    @Override
    public void raw(String message, byte[] data) {
        if (this.logRawBytes) {
            this.logWithHexDump(message + " (" + data.length + "): ", data, data.length);
        }
    }

    @Override
    public void raw(String message, ByteBuffer data, int offset, int length) {
        if (this.logRawBytes) {
            this.logWithHexDump(message + " (" + length + "): ", data, offset, length);
        }
    }

    @Override
    public void raw(String message, byte[] data, int length) {
        if (this.logRawBytes) {
            this.logWithHexDump(message + " (" + data.length + "): ", data, length);
        }
    }

    @Override
    public void decrypted(String message, byte[] data) {
        if (this.logDecrypted) {
            this.logWithHexDump(message + " (" + data.length + "): ", data, data.length);
        }
    }

    @Override
    public void decrypted(String message, byte[] data, int length) {
        if (this.logDecrypted) {
            this.logWithHexDump(message + " (" + data.length + "): ", data, length);
        }
    }

    @Override
    public void decrypted(String message) {
        if (this.logDecrypted) {
            this.log(message);
        }
    }

    @Override
    public void encrypted(String message, byte[] data) {
    }

    @Override
    public void error(String message) {
        this.log(this.formatTime() + " Error: " + message);
    }

    @Override
    public void error(String message, Throwable error) {
        this.log(this.formatTime() + " Error: " + message + ": " + error, error);
    }

    @Override
    public void recovery(String message) {
        if (this.logRecovery) {
            this.log(this.formatTime() + " " + message);
        }
    }

    @Override
    public void recovery(String message, Instant time) {
        if (this.logRecovery) {
            this.log(String.format(message, this.formatTime(time)));
        }
    }

    @Override
    public void cc(String message) {
        if (this.logCongestionControl) {
            this.log(this.formatTime(Instant.now()) + " " + message);
        }
    }

    @Override
    public void fc(String message) {
        if (this.logFlowControl) {
            this.log(this.formatTime(Instant.now()) + " " + message);
        }
    }

    @Override
    public void stats(String message) {
        if (this.logStats) {
            this.log(message);
        }
    }

    protected String byteToHex(byte[] data) {
        Object result = "";
        for (int i = 0; i < data.length; ++i) {
            result = (String)result + String.format("%02x ", data[i]);
        }
        return result;
    }

    protected String byteToHexBlock(byte[] data, int length) {
        Object result = "";
        int i = 0;
        while (i < length) {
            result = (String)result + String.format("%02x ", data[i]);
            if (++i >= data.length) continue;
            if (i % 16 == 0) {
                result = (String)result + "\n";
                continue;
            }
            if (i % 8 != 0) continue;
            result = (String)result + " ";
        }
        return result;
    }

    protected String byteToHexBlock(ByteBuffer data, int offset, int length) {
        data.rewind();
        Object result = "";
        int i = 0;
        while (i < length) {
            result = (String)result + String.format("%02x ", data.get(offset + i));
            if (++i >= length) continue;
            if (i % 16 == 0) {
                result = (String)result + "\n";
                continue;
            }
            if (i % 8 != 0) continue;
            result = (String)result + " ";
        }
        return result;
    }

    protected String formatTime() {
        return this.formatTime(Instant.now());
    }

    protected String formatTime(Instant time) {
        if (this.useRelativeTime) {
            if (this.start == null) {
                this.start = time;
            }
            Duration relativeTime = Duration.between(this.start, time);
            return String.format("%.3f", (double)relativeTime.toNanos() / 1.0E9);
        }
        LocalDateTime localTimeNow = LocalDateTime.from(time.atZone(ZoneId.systemDefault()));
        return this.timeFormatter.format(localTimeNow);
    }

    @Override
    public QLog getQLog() {
        return new NullQLog();
    }

    protected abstract void log(String var1);

    protected abstract void log(String var1, Throwable var2);

    protected abstract void logWithHexDump(String var1, byte[] var2, int var3);

    protected abstract void logWithHexDump(String var1, ByteBuffer var2, int var3, int var4);
}

