/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.packet;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.PnSpace;
import net.luminis.quic.Version;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.packet.LongHeaderPacket;

public class HandshakePacket
extends LongHeaderPacket {
    private static int V1_type = 2;
    private static int V2_type = 3;

    public static boolean isHandshake(int type, Version quicVersion) {
        if (quicVersion.isV2()) {
            return type == V2_type;
        }
        return type == V1_type;
    }

    public HandshakePacket(Version quicVersion) {
        super(quicVersion);
    }

    public HandshakePacket(Version quicVersion, byte[] sourceConnectionId, byte[] destConnectionId, QuicFrame payload) {
        super(quicVersion, sourceConnectionId, destConnectionId, payload);
    }

    @Override
    public HandshakePacket copy() {
        return new HandshakePacket(this.quicVersion, this.sourceConnectionId, this.destinationConnectionId, this.frames.size() > 0 ? (QuicFrame)this.frames.get(0) : null);
    }

    @Override
    protected byte getPacketType() {
        if (this.quicVersion.isV2()) {
            return (byte)V2_type;
        }
        return (byte)V1_type;
    }

    @Override
    protected void generateAdditionalFields(ByteBuffer packetBuffer) {
    }

    @Override
    protected int estimateAdditionalFieldsLength() {
        return 0;
    }

    @Override
    public EncryptionLevel getEncryptionLevel() {
        return EncryptionLevel.Handshake;
    }

    @Override
    public PnSpace getPnSpace() {
        return PnSpace.Handshake;
    }

    @Override
    public PacketProcessor.ProcessResult accept(PacketProcessor processor, Instant time) {
        return processor.process(this, time);
    }

    @Override
    protected void parseAdditionalFields(ByteBuffer buffer) {
    }
}

