/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.qlog;

import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.luminis.quic.qlog.ConnectionQLog;
import net.luminis.quic.qlog.QLogEvent;
import net.luminis.quic.qlog.event.ConnectionCreatedEvent;
import net.luminis.quic.qlog.event.ConnectionTerminatedEvent;

public class QLogBackEnd {
    private final BlockingQueue<QLogEvent> queue = new LinkedBlockingQueue<QLogEvent>();
    private Map<byte[], ConnectionQLog> connections = new ConcurrentHashMap<byte[], ConnectionQLog>();

    public QLogBackEnd() {
        Thread qlogWriterThread = new Thread(() -> this.generateConnectionLog());
        qlogWriterThread.setDaemon(true);
        qlogWriterThread.setPriority(1);
        qlogWriterThread.setName("qlog-writer");
        qlogWriterThread.start();
    }

    public Queue<QLogEvent> getQueue() {
        return this.queue;
    }

    private void generateConnectionLog() {
        while (true) {
            try {
                while (true) {
                    QLogEvent event;
                    if ((event = this.queue.poll(63000L, TimeUnit.MILLISECONDS)) != null) {
                        ConnectionQLog connectionQLog;
                        if (event instanceof ConnectionCreatedEvent) {
                            this.connections.put(event.getCid(), new ConnectionQLog(event));
                        }
                        if ((connectionQLog = this.connections.get(event.getCid())) == null) continue;
                        event.accept(connectionQLog);
                        if (!(event instanceof ConnectionTerminatedEvent)) continue;
                        this.connections.remove(event.getCid());
                        continue;
                    }
                    this.connections.values().stream().forEach(log -> log.close());
                    this.connections.clear();
                }
            }
            catch (IOException | InterruptedException exception) {
                continue;
            }
            break;
        }
    }
}

