/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.recovery;

import java.io.Serializable;
import java.time.Instant;
import java.util.function.Consumer;
import net.luminis.quic.packet.PacketInfo;
import net.luminis.quic.packet.QuicPacket;

class PacketStatus
extends PacketInfo {
    private boolean lost;
    private boolean acked;

    public PacketStatus(Instant sent, QuicPacket packet, Consumer<QuicPacket> lostPacketCallback) {
        super(sent, packet, lostPacketCallback);
    }

    public synchronized boolean acked() {
        return this.acked;
    }

    public synchronized boolean setAcked() {
        if (!this.acked && !this.lost) {
            this.acked = true;
            return true;
        }
        return false;
    }

    public synchronized boolean inFlight() {
        return !this.acked && !this.lost;
    }

    public synchronized boolean setLost() {
        if (!this.acked && !this.lost) {
            this.lost = true;
            return true;
        }
        return false;
    }

    public String status() {
        if (this.acked) {
            return "Acked";
        }
        if (this.lost) {
            return "Lost";
        }
        return "Inflight";
    }

    @Override
    public String toString() {
        return "Packet " + this.packet().getEncryptionLevel().name().charAt(0) + "|" + (Serializable)(this.packet().getPacketNumber() >= 0L ? this.packet().getPacketNumber() : ".") + "| |" + this.packet().getSize() + "|" + this.status();
    }
}

